/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.DefaultTimer;
import org.gradle.internal.time.TimeSource;

class DefaultCountdownTimer
extends DefaultTimer
implements CountdownTimer {
    private final long timeoutMillis;

    DefaultCountdownTimer(TimeSource timeSource, long timeout, TimeUnit unit) {
        super(timeSource);
        Preconditions.checkArgument(timeout > 0L);
        this.timeoutMillis = unit.toMillis(timeout);
    }

    @Override
    public boolean hasExpired() {
        return this.getRemainingMillis() <= 0L;
    }

    @Override
    public long getRemainingMillis() {
        return Math.max(this.timeoutMillis - this.getElapsedMillis(), 0L);
    }

    @Override
    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }
}

