/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.internal.util.gradle.HierarchicalElementUtils;
import org.eclipse.buildship.ui.internal.view.task.BuildNode;
import org.eclipse.buildship.ui.internal.view.task.BuildTreeNode;
import org.eclipse.core.resources.IProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class TaskViewContent {
    private final List<BuildNode> allBuilds;
    private final List<IProject> faultyWorkspaceProjects;

    private TaskViewContent(List<BuildNode> allBuilds, List<IProject> faultyWorkspaceProjects) {
        this.allBuilds = allBuilds;
        this.faultyWorkspaceProjects = faultyWorkspaceProjects;
    }

    public List<IProject> getFaultyWorkspaceProjects() {
        return this.faultyWorkspaceProjects;
    }

    public boolean isEmpty() {
        return this.allBuilds.isEmpty() && this.faultyWorkspaceProjects.isEmpty();
    }

    public Collection<BuildNode> getBuilds() {
        return this.allBuilds;
    }

    public static TaskViewContent from(Map<File, Map<String, EclipseProject>> allModels, Map<File, BuildEnvironment> environments, Map<String, IProject> allGradleWorkspaceProjects) {
        ArrayList<BuildNode> builds = new ArrayList<BuildNode>();
        for (Map.Entry<File, Map<String, EclipseProject>> model : allModels.entrySet()) {
            File rootProjectDir = model.getKey();
            BuildEnvironment buildEnvironment = environments.get(rootProjectDir);
            BuildTreeNode buildTreeNode = new BuildTreeNode(rootProjectDir, buildEnvironment);
            for (Map.Entry<String, EclipseProject> entry : model.getValue().entrySet()) {
                String includedBuildName = entry.getKey().equals(":") ? null : entry.getKey();
                EclipseProject rootEclipseProject = entry.getValue();
                builds.add(new BuildNode(buildTreeNode, rootEclipseProject, includedBuildName));
            }
        }
        List<IProject> faultyWorkspaceProjects = TaskViewContent.collectFaultyWorkspaceProjects(allGradleWorkspaceProjects, builds);
        return new TaskViewContent(builds, faultyWorkspaceProjects);
    }

    private static List<IProject> collectFaultyWorkspaceProjects(Map<String, IProject> workspaceProjects, List<BuildNode> builds) {
        LinkedHashMap<String, IProject> result = new LinkedHashMap<String, IProject>(workspaceProjects);
        for (EclipseProject p : TaskViewContent.collectAllEclipseProjects(builds)) {
            result.remove(p.getName());
        }
        return new ArrayList<IProject>(result.values());
    }

    private static List<EclipseProject> collectAllEclipseProjects(List<BuildNode> builds) {
        return builds.stream().map(BuildNode::getRootEclipseProject).flatMap(p -> HierarchicalElementUtils.getAll((EclipseProject)p).stream()).collect(Collectors.toList());
    }
}

