/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.buildship.ui.view.Page;
import org.eclipse.buildship.ui.view.execution.OperationItem;
import org.eclipse.buildship.ui.view.execution.OperationItemRenderer;
import org.eclipse.buildship.ui.view.execution.UpdateDurationJob;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.StartEvent;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;

public final class ExecutionProgressListener
implements ProgressListener {
    private static final int UPDATE_DURATION_JOB_INTERVAL_IN_MS = 1000;
    private final Page executionPage;
    private final Map<OperationDescriptor, OperationItem> executionItemMap;
    private final OperationItemRenderer operationItemRenderer;
    private UpdateDurationJob updateDurationJob;

    public ExecutionProgressListener(Page executionPage, OperationItem root) {
        this.executionPage = (Page)Preconditions.checkNotNull((Object)executionPage);
        this.executionItemMap = Maps.newLinkedHashMap();
        this.executionItemMap.put(null, (OperationItem)Preconditions.checkNotNull((Object)root));
        this.operationItemRenderer = new OperationItemRenderer();
    }

    public void statusChanged(ProgressEvent progressEvent) {
        OperationDescriptor descriptor = progressEvent.getDescriptor();
        if (this.isExcluded(descriptor)) {
            return;
        }
        this.initDurationJobIfNeeded();
        OperationItem operationItem = this.executionItemMap.get(descriptor);
        if (null == operationItem) {
            operationItem = new OperationItem((StartEvent)progressEvent);
            this.executionItemMap.put(descriptor, operationItem);
            this.updateDurationJob.addOperationItem(operationItem);
        } else {
            operationItem.setFinishEvent((FinishEvent)progressEvent);
            this.updateDurationJob.removeOperationItem(operationItem);
        }
        this.operationItemRenderer.update(operationItem);
        OperationItem parentExecutionItem = this.executionItemMap.get(this.findFirstNonExcludedParent(descriptor));
        parentExecutionItem.addChild(operationItem);
        if (operationItem.getFinishEvent() == null) {
            this.makeNodeVisible(operationItem);
        }
    }

    private void initDurationJobIfNeeded() {
        if (this.updateDurationJob == null) {
            this.updateDurationJob = new UpdateDurationJob(1000L, this.operationItemRenderer);
            this.updateDurationJob.schedule(1000L);
        }
    }

    private boolean isExcluded(OperationDescriptor descriptor) {
        if (descriptor instanceof JvmTestOperationDescriptor) {
            JvmTestOperationDescriptor jvmTestOperationDescriptor = (JvmTestOperationDescriptor)descriptor;
            return jvmTestOperationDescriptor.getSuiteName() != null && jvmTestOperationDescriptor.getClassName() == null;
        }
        return false;
    }

    private OperationDescriptor findFirstNonExcludedParent(OperationDescriptor descriptor) {
        while (this.isExcluded(descriptor.getParent())) {
            descriptor = descriptor.getParent();
        }
        return descriptor.getParent();
    }

    private void makeNodeVisible(final OperationItem operationItem) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer treeViewer = (TreeViewer)ExecutionProgressListener.this.executionPage.getAdapter(TreeViewer.class);
                treeViewer.expandToLevel((Object)operationItem, -1);
            }
        });
    }
}

