/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.gradleware.tooling.toolingmodel.OmniClasspathEntry;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectDependency;
import com.gradleware.tooling.toolingmodel.OmniExternalDependency;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.util.classpath.ClasspathUtils;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.buildship.core.workspace.internal.ClasspathContainerPersistence;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.gradle.tooling.model.eclipse.EclipseProjectIdentifier;

final class GradleClasspathContainerUpdater {
    private final IJavaProject eclipseProject;
    private final OmniEclipseProject gradleProject;
    private final Map<EclipseProjectIdentifier, OmniEclipseProject> idsToAllProjects;

    private GradleClasspathContainerUpdater(IJavaProject eclipseProject, OmniEclipseProject gradleProject) {
        this.eclipseProject = (IJavaProject)Preconditions.checkNotNull((Object)eclipseProject);
        this.gradleProject = (OmniEclipseProject)Preconditions.checkNotNull((Object)gradleProject);
        this.idsToAllProjects = Maps.newHashMap();
        for (OmniEclipseProject project : gradleProject.getRoot().getAll()) {
            this.idsToAllProjects.put(project.getIdentifier(), project);
        }
    }

    private void updateClasspathContainer(IProgressMonitor monitor) throws JavaModelException {
        ImmutableList<IClasspathEntry> containerEntries = this.collectClasspathContainerEntries();
        GradleClasspathContainerUpdater.setClasspathContainer(this.eclipseProject, containerEntries, monitor);
        ClasspathContainerPersistence.save(this.eclipseProject, containerEntries);
    }

    private ImmutableList<IClasspathEntry> collectClasspathContainerEntries() {
        ImmutableList projectDependencies = FluentIterable.from((Iterable)this.gradleProject.getProjectDependencies()).transform((Function)new Function<OmniEclipseProjectDependency, IClasspathEntry>(){

            public IClasspathEntry apply(OmniEclipseProjectDependency dependency) {
                OmniEclipseProject targetProject = (OmniEclipseProject)GradleClasspathContainerUpdater.this.idsToAllProjects.get(dependency.getTarget());
                String actualName = CorePlugin.workspaceOperations().normalizeProjectName(targetProject.getName(), targetProject.getProjectDirectory());
                Path path = new Path("/" + actualName);
                return JavaCore.newProjectEntry((IPath)path, (IAccessRule[])ClasspathUtils.createAccessRules((OmniClasspathEntry)dependency), (boolean)true, (IClasspathAttribute[])ClasspathUtils.createClasspathAttributes((OmniClasspathEntry)dependency), (boolean)dependency.isExported());
            }
        }).toList();
        ImmutableList externalDependencies = FluentIterable.from((Iterable)this.gradleProject.getExternalDependencies()).filter((Predicate)new Predicate<OmniExternalDependency>(){

            public boolean apply(OmniExternalDependency dependency) {
                File file = dependency.getFile();
                String name = file.getName();
                return file.isDirectory() || name.endsWith(".jar") || name.endsWith(".zip");
            }
        }).transform((Function)new Function<OmniExternalDependency, IClasspathEntry>(){

            public IClasspathEntry apply(OmniExternalDependency dependency) {
                IPath file = Path.fromOSString((String)dependency.getFile().getAbsolutePath());
                IPath sources = dependency.getSource() != null ? Path.fromOSString((String)dependency.getSource().getAbsolutePath()) : null;
                return JavaCore.newLibraryEntry((IPath)file, (IPath)sources, null, (IAccessRule[])ClasspathUtils.createAccessRules((OmniClasspathEntry)dependency), (IClasspathAttribute[])ClasspathUtils.createClasspathAttributes((OmniClasspathEntry)dependency), (boolean)dependency.isExported());
            }
        }).toList();
        return ImmutableList.builder().addAll((Iterable)externalDependencies).addAll((Iterable)projectDependencies).build();
    }

    public static void updateFromModel(IJavaProject eclipseProject, OmniEclipseProject gradleProject, IProgressMonitor monitor) throws JavaModelException {
        GradleClasspathContainerUpdater updater = new GradleClasspathContainerUpdater(eclipseProject, gradleProject);
        updater.updateClasspathContainer(monitor);
    }

    public static boolean updateFromStorage(IJavaProject eclipseProject, IProgressMonitor monitor) throws JavaModelException {
        Optional<List<IClasspathEntry>> storedClasspath = ClasspathContainerPersistence.load(eclipseProject);
        if (storedClasspath.isPresent()) {
            GradleClasspathContainerUpdater.setClasspathContainer(eclipseProject, (List)storedClasspath.get(), monitor);
            return true;
        }
        return false;
    }

    public static void clear(IJavaProject eclipseProject, IProgressMonitor monitor) throws JavaModelException {
        GradleClasspathContainerUpdater.setClasspathContainer(eclipseProject, (List<IClasspathEntry>)ImmutableList.of(), monitor);
    }

    private static void setClasspathContainer(IJavaProject eclipseProject, List<IClasspathEntry> classpathEntries, IProgressMonitor monitor) throws JavaModelException {
        IClasspathContainer classpathContainer = GradleClasspathContainer.newInstance(classpathEntries);
        JavaCore.setClasspathContainer((IPath)GradleClasspathContainer.CONTAINER_PATH, (IJavaProject[])new IJavaProject[]{eclipseProject}, (IClasspathContainer[])new IClasspathContainer[]{classpathContainer}, (IProgressMonitor)monitor);
    }
}

