/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.gradle.Specs;
import org.eclipse.buildship.core.util.predicate.Predicates;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.buildship.core.workspace.WorkspaceGradleOperations;
import org.eclipse.buildship.core.workspace.internal.ClasspathContainerUpdater;
import org.eclipse.buildship.core.workspace.internal.DefaultProjectCreatedEvent;
import org.eclipse.buildship.core.workspace.internal.LinkedResourcesUpdater;
import org.eclipse.buildship.core.workspace.internal.ResourceFilter;
import org.eclipse.buildship.core.workspace.internal.SourceFolderUpdater;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.gradle.api.specs.Spec;

public final class DefaultWorkspaceGradleOperations
implements WorkspaceGradleOperations {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeGradleBuildWithWorkspace(OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes rootRequestAttributes, List<String> workingSets, IProgressMonitor monitor) {
        List allGradleProjects = gradleBuild.getRootEclipseProject().getAll();
        List<IProject> decoupledWorkspaceProjects = this.collectOpenWorkspaceProjectsRemovedFromGradleBuild(allGradleProjects, rootRequestAttributes);
        monitor.beginTask("Synchronize Gradle build with workspace", decoupledWorkspaceProjects.size() + allGradleProjects.size());
        try {
            for (IProject project : decoupledWorkspaceProjects) {
                this.uncoupleWorkspaceProjectFromGradle(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            for (OmniEclipseProject gradleProject : allGradleProjects) {
                this.synchronizeGradleProjectWithWorkspaceProject(gradleProject, gradleBuild, rootRequestAttributes, workingSets, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private List<IProject> collectOpenWorkspaceProjectsRemovedFromGradleBuild(List<OmniEclipseProject> gradleProjects, final FixedRequestAttributes rootRequestAttributes) {
        ImmutableSet gradleProjectDirectories = FluentIterable.from(gradleProjects).transform((Function)new Function<OmniEclipseProject, File>(){

            public File apply(OmniEclipseProject gradleProject) {
                return gradleProject.getProjectDirectory();
            }
        }).toSet();
        ImmutableList<IProject> allWorkspaceProjects = CorePlugin.workspaceOperations().getAllProjects();
        return FluentIterable.from(allWorkspaceProjects).filter(Predicates.accessibleGradleProject()).filter((Predicate)new Predicate<IProject>((Set)gradleProjectDirectories){
            final /* synthetic */ Set val$gradleProjectDirectories;
            {
                this.val$gradleProjectDirectories = set;
            }

            public boolean apply(IProject project) {
                ProjectConfiguration projectConfiguration = CorePlugin.projectConfigurationManager().readProjectConfiguration(project);
                return projectConfiguration.getRequestAttributes().getProjectDir().equals(rootRequestAttributes.getProjectDir()) && (project.getLocation() == null || !this.val$gradleProjectDirectories.contains(project.getLocation().toFile()));
            }
        }).toList();
    }

    @Override
    public void synchronizeGradleProjectWithWorkspaceProject(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes rootRequestAttributes, List<String> workingSets, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Synchronize Gradle project %s with workspace project", project.getName()), 2);
        try {
            Optional<IProject> workspaceProject = CorePlugin.workspaceOperations().findProjectByLocation(project.getProjectDirectory());
            if (workspaceProject.isPresent()) {
                this.synchronizeWorkspaceProject(project, gradleBuild, (IProject)workspaceProject.get(), rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                this.synchronizeNonWorkspaceProject(project, gradleBuild, rootRequestAttributes, workingSets, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (CoreException e) {
            String message = String.format("Cannot synchronize Gradle project %s with workspace project.", project.getName());
            CorePlugin.logger().error(message, e);
            throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeWorkspaceProject(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, IProject workspaceProject, FixedRequestAttributes rootRequestAttributes, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.format("Synchronize Gradle project %s that is already in the workspace", project.getName()), 1);
        try {
            if (workspaceProject.isAccessible()) {
                this.synchronizeOpenWorkspaceProject(project, gradleBuild, workspaceProject, rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                this.synchronizeClosedWorkspaceProject();
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeOpenWorkspaceProject(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, IProject workspaceProject, FixedRequestAttributes rootRequestAttributes, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.format("Synchronize Gradle project %s that is open in the workspace", project.getName()), 6);
        try {
            CorePlugin.workspaceOperations().addNature(workspaceProject, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (rootRequestAttributes != null) {
                ProjectConfiguration configuration = ProjectConfiguration.from(rootRequestAttributes, project);
                CorePlugin.projectConfigurationManager().saveProjectConfiguration(configuration, workspaceProject);
            }
            List<File> filteredSubFolders = this.getFilteredSubFolders(project, gradleBuild);
            ResourceFilter.attachFilters(workspaceProject, filteredSubFolders, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            LinkedResourcesUpdater.update(workspaceProject, project.getLinkedResources(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.isJavaProject(project) && !this.hasJavaNature(workspaceProject)) {
                IPath jrePath = JavaRuntime.getDefaultJREContainerEntry().getPath();
                IClasspathEntry classpathContainer = GradleClasspathContainer.newClasspathEntry();
                CorePlugin.workspaceOperations().createJavaProject(workspaceProject, jrePath, classpathContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            if (this.hasJavaNature(workspaceProject)) {
                IJavaProject javaProject = JavaCore.create((IProject)workspaceProject);
                SourceFolderUpdater.update(javaProject, project.getSourceDirectories(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ClasspathContainerUpdater.update(javaProject, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(2);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void synchronizeClosedWorkspaceProject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeNonWorkspaceProject(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes rootRequestAttributes, List<String> workingSets, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.format("Synchronize Gradle project %s that is not yet in the workspace", project.getName()), 2);
        try {
            Optional<IProjectDescription> projectDescription = CorePlugin.workspaceOperations().findProjectInFolder(project.getProjectDirectory(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IProject workspaceProject = projectDescription.isPresent() ? this.addExistingEclipseProjectToWorkspace(project, (IProjectDescription)projectDescription.get(), rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1)) : this.addNewEclipseProjectToWorkspace(project, gradleBuild, rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            DefaultProjectCreatedEvent event = new DefaultProjectCreatedEvent(workspaceProject, workingSets);
            CorePlugin.listenerRegistry().dispatch(event);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProject addExistingEclipseProjectToWorkspace(OmniEclipseProject project, IProjectDescription projectDescription, FixedRequestAttributes rootRequestAttributes, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Add existing Eclipse project %s for Gradle project %s to the workspace", projectDescription.getName(), project.getName()), 1);
        try {
            ImmutableList gradleNature = ImmutableList.of((Object)"org.eclipse.buildship.core.gradleprojectnature");
            IProject workspaceProject = CorePlugin.workspaceOperations().includeProject(projectDescription, (List<String>)gradleNature, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ProjectConfiguration projectConfiguration = ProjectConfiguration.from(rootRequestAttributes, project);
            CorePlugin.projectConfigurationManager().saveProjectConfiguration(projectConfiguration, workspaceProject);
            IProject iProject = workspaceProject;
            return iProject;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProject addNewEclipseProjectToWorkspace(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes rootRequestAttributes, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.format("Add new Eclipse project for Gradle project %s to the workspace", project.getName()), 4);
        try {
            ImmutableList gradleNature = ImmutableList.of((Object)"org.eclipse.buildship.core.gradleprojectnature");
            IProject workspaceProject = CorePlugin.workspaceOperations().createProject(project.getName(), project.getProjectDirectory(), (List<String>)gradleNature, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ProjectConfiguration projectConfiguration = ProjectConfiguration.from(rootRequestAttributes, project);
            CorePlugin.projectConfigurationManager().saveProjectConfiguration(projectConfiguration, workspaceProject);
            List<File> filteredSubFolders = this.getFilteredSubFolders(project, gradleBuild);
            ResourceFilter.attachFilters(workspaceProject, filteredSubFolders, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            LinkedResourcesUpdater.update(workspaceProject, project.getLinkedResources(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.isJavaProject(project)) {
                IPath jrePath = JavaRuntime.getDefaultJREContainerEntry().getPath();
                IClasspathEntry classpathContainer = GradleClasspathContainer.newClasspathEntry();
                CorePlugin.workspaceOperations().createJavaProject(workspaceProject, jrePath, classpathContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            IProject iProject = workspaceProject;
            return iProject;
        }
        finally {
            monitor.done();
        }
    }

    private List<File> getFilteredSubFolders(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild) {
        return ImmutableList.builder().addAll(this.collectChildProjectLocations(project)).add((Object)this.getBuildDirectory(gradleBuild, project)).add((Object)this.getDotGradleDirectory(project)).build();
    }

    private List<File> collectChildProjectLocations(OmniEclipseProject project) {
        return FluentIterable.from((Iterable)project.getChildren()).transform((Function)new Function<OmniEclipseProject, File>(){

            public File apply(OmniEclipseProject project) {
                return project.getProjectDirectory();
            }
        }).toList();
    }

    private File getBuildDirectory(OmniEclipseGradleBuild eclipseGradleBuild, OmniEclipseProject project) {
        Optional gradleProject = eclipseGradleBuild.getRootProject().tryFind(Specs.gradleProjectMatchesProjectPath(project.getPath()));
        Maybe buildScript = ((OmniGradleProject)gradleProject.get()).getBuildDirectory();
        if (buildScript.isPresent() && buildScript.get() != null) {
            return (File)buildScript.get();
        }
        return new File(project.getProjectDirectory(), "build");
    }

    private File getDotGradleDirectory(OmniEclipseProject project) {
        return new File(project.getProjectDirectory(), ".gradle");
    }

    private boolean isJavaProject(OmniEclipseProject project) {
        return !project.getSourceDirectories().isEmpty();
    }

    private boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeWorkspaceProject(final IProject workspaceProject, OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes rootRequestAttributes, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Synchronize workspace project %s with Gradle build", workspaceProject.getName()), 10);
        try {
            Optional gradleProject;
            if (GradleProjectNature.INSTANCE.isPresentOn(workspaceProject) && (gradleProject = gradleBuild.getRootEclipseProject().tryFind((Spec)new Spec<OmniEclipseProject>(){

                public boolean isSatisfiedBy(OmniEclipseProject gradleProject) {
                    return workspaceProject.getLocation() != null && workspaceProject.getLocation().toFile().equals(gradleProject.getProjectDirectory());
                }
            })).isPresent()) {
                this.synchronizeGradleProjectWithWorkspaceProject((OmniEclipseProject)gradleProject.get(), gradleBuild, rootRequestAttributes, (List<String>)ImmutableList.of(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                return;
            }
            this.uncoupleWorkspaceProjectFromGradle(workspaceProject, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            this.clearClasspathContainer(workspaceProject, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        }
        finally {
            monitor.done();
        }
    }

    private void clearClasspathContainer(IProject workspaceProject, IProgressMonitor monitor) {
        try {
            if (this.hasJavaNature(workspaceProject)) {
                IJavaProject javaProject = JavaCore.create((IProject)workspaceProject);
                ClasspathContainerUpdater.clear(javaProject, monitor);
            }
        }
        catch (JavaModelException e) {
            String message = String.format("Cannot clear classpath container from workspace project %s", workspaceProject.getName());
            CorePlugin.logger().error(message, e);
            throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncoupleWorkspaceProjectFromGradle(IProject workspaceProject, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Uncouple workspace project %s from Gradle", workspaceProject.getName()), 1);
        try {
            CorePlugin.workspaceOperations().removeNature(workspaceProject, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CorePlugin.projectConfigurationManager().deleteProjectConfiguration(workspaceProject);
        }
        finally {
            monitor.done();
        }
    }
}

