/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.preferences;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.buildship.core.internal.preferences.AbsentPersistentModel;
import org.eclipse.buildship.core.internal.preferences.BuildCommandConverter;
import org.eclipse.buildship.core.internal.preferences.ClasspathConverter;
import org.eclipse.buildship.core.internal.preferences.DefaultPersistentModel;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

final class PersistentModelConverter {
    private static final String PROPERTY_BUILD_DIR = "buildDir";
    private static final String PROPERTY_BUILD_SCRIPT_PATH = "buildScriptPath";
    private static final String PROPERTY_SUBPROJECTS = "subprojectPaths";
    private static final String PROPERTY_CLASSPATH = "classpath";
    private static final String PROPERTY_DERIVED_RESOURCES = "derivedResources";
    private static final String PROPERTY_LINKED_RESOURCES = "linkedResources";
    private static final String PROPERTY_MANAGED_NATURES = "managedNatures";
    private static final String PROPERTY_MANAGED_BUILDERS = "managedBuilders";
    private static final String PROPERTY_HAS_AUTOBUILD_TASKS = "hasAutoBuildTasks";
    private static final String PROPERTY_GRADLE_VERSION = "gradleVersion";

    PersistentModelConverter() {
    }

    public static Properties toProperties(final PersistentModel model) {
        Properties properties = new Properties();
        PersistentModelConverter.storeValue(properties, PROPERTY_BUILD_DIR, model.getBuildDir(), new Function<IPath, String>(){

            public String apply(IPath path) {
                return path.toPortableString();
            }
        });
        PersistentModelConverter.storeValue(properties, PROPERTY_BUILD_SCRIPT_PATH, model.getbuildScriptPath(), new Function<IPath, String>(){

            public String apply(IPath path) {
                return path.toPortableString();
            }
        });
        PersistentModelConverter.storeList(properties, PROPERTY_SUBPROJECTS, model.getSubprojectPaths(), new Function<IPath, String>(){

            public String apply(IPath path) {
                return path.toPortableString();
            }
        });
        PersistentModelConverter.storeValue(properties, PROPERTY_CLASSPATH, model.getClasspath(), new Function<List<IClasspathEntry>, String>(){

            public String apply(List<IClasspathEntry> classpath) {
                IJavaProject javaProject = JavaCore.create((IProject)model.getProject());
                return ClasspathConverter.toXml(javaProject, classpath);
            }
        });
        PersistentModelConverter.storeList(properties, PROPERTY_DERIVED_RESOURCES, model.getDerivedResources(), new Function<IPath, String>(){

            public String apply(IPath path) {
                return path.toPortableString();
            }
        });
        PersistentModelConverter.storeList(properties, PROPERTY_LINKED_RESOURCES, model.getLinkedResources(), new Function<IPath, String>(){

            public String apply(IPath linkedResource) {
                return linkedResource.toPortableString();
            }
        });
        PersistentModelConverter.storeList(properties, PROPERTY_MANAGED_NATURES, model.getManagedNatures(), Functions.identity());
        PersistentModelConverter.storeValue(properties, PROPERTY_MANAGED_BUILDERS, model.getManagedBuilders(), new Function<List<ICommand>, String>(){

            public String apply(List<ICommand> commands) {
                return BuildCommandConverter.toXml(model.getProject(), commands);
            }
        });
        PersistentModelConverter.storeValue(properties, PROPERTY_HAS_AUTOBUILD_TASKS, model.hasAutoBuildTasks(), new Function<Boolean, String>(){

            public String apply(Boolean hasAutoBuildTasks) {
                return hasAutoBuildTasks.toString();
            }
        });
        PersistentModelConverter.storeValue(properties, PROPERTY_GRADLE_VERSION, model.getGradleVersion(), new Function<GradleVersion, String>(){

            public String apply(GradleVersion gradleVersion) {
                return gradleVersion.getVersion();
            }
        });
        return properties;
    }

    public static PersistentModel toModel(final IProject project, Properties properties) {
        IPath buildDir = PersistentModelConverter.loadValue(properties, PROPERTY_BUILD_DIR, new Path("build"), new Function<String, IPath>(){

            public IPath apply(String path) {
                return new Path(path);
            }
        });
        IPath buildScriptPath = PersistentModelConverter.loadValue(properties, PROPERTY_BUILD_SCRIPT_PATH, new Path("build.gradle"), new Function<String, IPath>(){

            public IPath apply(String path) {
                return new Path(path);
            }
        });
        List<IPath> subprojects = PersistentModelConverter.loadList(properties, PROPERTY_SUBPROJECTS, new Function<String, IPath>(){

            public IPath apply(String path) {
                return new Path(path);
            }
        });
        List<IClasspathEntry> classpath = PersistentModelConverter.loadValue(properties, PROPERTY_CLASSPATH, ImmutableList.of(), new Function<String, List<IClasspathEntry>>(){

            public List<IClasspathEntry> apply(String classpath) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                return ClasspathConverter.toEntries(javaProject, classpath);
            }
        });
        List<IPath> derivedResources = PersistentModelConverter.loadList(properties, PROPERTY_DERIVED_RESOURCES, new Function<String, IPath>(){

            public IPath apply(String path) {
                return new Path(path);
            }
        });
        List<IPath> linkedResources = PersistentModelConverter.loadList(properties, PROPERTY_LINKED_RESOURCES, new Function<String, IPath>(){

            public IPath apply(String path) {
                return new Path(path);
            }
        });
        List<String> managedNatures = PersistentModelConverter.loadList(properties, PROPERTY_MANAGED_NATURES, Functions.identity());
        Collection managedBuilders = PersistentModelConverter.loadValue(properties, PROPERTY_MANAGED_BUILDERS, ImmutableList.of(), new Function<String, List<ICommand>>(){

            public List<ICommand> apply(String commands) {
                return BuildCommandConverter.toEntries(project, commands);
            }
        });
        boolean hasAutoBuildTasks = PersistentModelConverter.loadValue(properties, PROPERTY_HAS_AUTOBUILD_TASKS, Boolean.FALSE, new Function<String, Boolean>(){

            public Boolean apply(String hasAutoBuildTasks) {
                return Boolean.valueOf(hasAutoBuildTasks);
            }
        });
        GradleVersion gradleVersion = PersistentModelConverter.loadValue(properties, PROPERTY_GRADLE_VERSION, null, new Function<String, GradleVersion>(){

            public GradleVersion apply(String version) {
                return GradleVersion.version(version);
            }
        });
        if (gradleVersion == null) {
            return new AbsentPersistentModel(project);
        }
        return new DefaultPersistentModel(project, buildDir, buildScriptPath, subprojects, classpath, derivedResources, linkedResources, managedNatures, managedBuilders, hasAutoBuildTasks, gradleVersion);
    }

    private static <T> T loadValue(Properties properties, String key, T defaultValue, Function<String, T> conversion) {
        String value = (String)properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)conversion.apply((Object)value);
    }

    private static <T> List<T> loadList(Properties properties, String key, Function<String, T> conversion) {
        String values = (String)properties.get(key);
        if (values == null) {
            return ImmutableList.of();
        }
        List collection = Splitter.on((String)File.pathSeparator).omitEmptyStrings().splitToList((CharSequence)values);
        return FluentIterable.from((Iterable)collection).transform(conversion).filter(Predicates.notNull()).toList();
    }

    private static <T> void storeValue(Properties properties, String key, T value, Function<T, String> conversion) {
        properties.put(key, conversion.apply(value));
    }

    private static <T> void storeList(Properties properties, String key, Collection<T> values, Function<T, String> conversion) {
        ImmutableList stringList = FluentIterable.from(values).transform(conversion).filter(Predicates.notNull()).toList();
        properties.put(key, Joiner.on((String)File.pathSeparator).join((Iterable)stringList));
    }
}

