/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.oomph.impl;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.GradleWorkspace;
import org.eclipse.buildship.oomph.ImportTaskMessages;
import org.eclipse.buildship.oomph.impl.GradleImportTaskImpl;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.osgi.util.NLS;

public class CustomGradleImportTaskImpl
extends GradleImportTaskImpl {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();

    @Override
    public boolean isNeeded(SetupTaskContext context) throws Exception {
        EList<SourceLocator> sourceLocators = this.getSourceLocators();
        if (sourceLocators.isEmpty()) {
            return false;
        }
        if (context.getTrigger() != Trigger.MANUAL) {
            return !this.calculateProjectsToImport().isEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(SetupTaskContext context) throws Exception {
        Object sourceLocators = this.getSourceLocators();
        if (context.getTrigger() != Trigger.MANUAL) {
            sourceLocators = this.calculateProjectsToImport();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)context.getProgressMonitor(true));
        monitor.beginTask("", sourceLocators.size());
        try {
            GradleWorkspace workspace = GradleCore.getWorkspace();
            Iterator iterator = sourceLocators.iterator();
            while (iterator.hasNext()) {
                SourceLocator sourceLocator = (SourceLocator)iterator.next();
                context.log(NLS.bind((String)ImportTaskMessages.GradleImportTaskImpl_importing, (Object)sourceLocator.getRootFolder()));
                SubMonitor progress = monitor.newChild(1);
                Optional gradleBuildHolder = Optional.empty();
                for (IProject project : ROOT.getProjects()) {
                    if (gradleBuildHolder.isPresent() || !project.getLocation().equals((Object)new Path(sourceLocator.getRootFolder()))) continue;
                    gradleBuildHolder = workspace.getBuild(project);
                    context.log(NLS.bind((String)ImportTaskMessages.GradleImportTaskImpl_found_existing, (Object)project.getName()));
                }
                GradleBuild gradleBuild = gradleBuildHolder.orElseGet(new GradleBuildSupplier(context, new File(sourceLocator.getRootFolder())));
                progress.setWorkRemaining(1);
                gradleBuild.synchronize((IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private List<SourceLocator> calculateProjectsToImport() {
        ArrayList<SourceLocator> projectsToImport = new ArrayList<SourceLocator>();
        for (SourceLocator sourceLocator : this.sourceLocators) {
            Path rootFolder = new Path(sourceLocator.getRootFolder());
            boolean projectPresentInWorkspace = false;
            for (IProject project : ROOT.getProjects()) {
                IPath projectFolder = project.getLocation();
                try {
                    if (!Files.isSameFile(Paths.get(projectFolder.toOSString(), new String[0]), Paths.get(rootFolder.toOSString(), new String[0]))) continue;
                    projectPresentInWorkspace = true;
                    break;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to compare project paths for equality", e);
                }
            }
            if (projectPresentInWorkspace) continue;
            projectsToImport.add(sourceLocator);
        }
        return projectsToImport;
    }

    private class GradleBuildSupplier
    implements Supplier<GradleBuild> {
        private final SetupTaskContext context;
        private final File rootFolder;

        public GradleBuildSupplier(SetupTaskContext context, File rootFolder) {
            this.context = context;
            this.rootFolder = rootFolder;
        }

        @Override
        public GradleBuild get() {
            GradleWorkspace workspace = GradleCore.getWorkspace();
            BuildConfiguration.BuildConfigurationBuilder configBuilder = BuildConfiguration.forRootProjectDirectory((File)this.rootFolder);
            if (CustomGradleImportTaskImpl.this.isOverrideWorkspaceSettings()) {
                configBuilder.overrideWorkspaceConfiguration(true);
                switch (CustomGradleImportTaskImpl.this.getDistributionType()) {
                    case GRADLE_WRAPPER: {
                        configBuilder.gradleDistribution((GradleDistribution)GradleDistribution.fromBuild());
                        break;
                    }
                    case LOCAL_INSTALLATION: {
                        configBuilder.gradleDistribution((GradleDistribution)GradleDistribution.forLocalInstallation((File)new File(CustomGradleImportTaskImpl.this.getLocalInstallationDirectory())));
                        break;
                    }
                    case REMOTE_DISTRIBUTION: {
                        try {
                            configBuilder.gradleDistribution((GradleDistribution)GradleDistribution.forRemoteDistribution((URI)new URI(CustomGradleImportTaskImpl.this.getRemoteDistributionLocation())));
                            break;
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalArgumentException("Invalid Gradle distribution uri " + CustomGradleImportTaskImpl.this.getRemoteDistributionLocation(), e);
                        }
                    }
                    case SPECIFIC_GRADLE_VERSION: {
                        configBuilder.gradleDistribution((GradleDistribution)GradleDistribution.forVersion((String)CustomGradleImportTaskImpl.this.getSpecificGradleVersion()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported distributionType " + CustomGradleImportTaskImpl.this.getDistributionType());
                    }
                }
                if (CustomGradleImportTaskImpl.this.getGradleUserHome() != null) {
                    configBuilder.gradleUserHome(new File(CustomGradleImportTaskImpl.this.getGradleUserHome()));
                }
                if (CustomGradleImportTaskImpl.this.getJavaHome() != null) {
                    configBuilder.javaHome(new File(CustomGradleImportTaskImpl.this.getJavaHome()));
                }
                configBuilder.arguments((List)CustomGradleImportTaskImpl.this.programArguments).jvmArguments(CustomGradleImportTaskImpl.this.getJvmArguments()).offlineMode(CustomGradleImportTaskImpl.this.isOfflineMode()).buildScansEnabled(CustomGradleImportTaskImpl.this.isBuildScans()).autoSync(CustomGradleImportTaskImpl.this.isAutomaticProjectSynchronization()).showConsoleView(CustomGradleImportTaskImpl.this.isShowConsoleView()).showExecutionsView(CustomGradleImportTaskImpl.this.isShowExecutionsView());
            }
            BuildConfiguration configuration = configBuilder.build();
            this.context.log(ImportTaskMessages.GradleImportTaskImpl_import_new);
            return workspace.createBuild(configuration);
        }
    }
}

