/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.composite.internal;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.composite.CompositeBuildConnection;
import org.gradle.tooling.composite.CompositeBuildConnector;
import org.gradle.tooling.composite.CompositeParticipant;
import org.gradle.tooling.composite.internal.DefaultCompositeBuildConnection;
import org.gradle.tooling.composite.internal.DefaultCompositeParticipant;
import org.gradle.tooling.composite.internal.deduplication.DeduplicatingCompositeBuildConnection;
import org.gradle.tooling.composite.internal.dist.GradleDistribution;
import org.gradle.tooling.composite.internal.dist.InstalledGradleDistribution;
import org.gradle.tooling.composite.internal.dist.URILocatedGradleDistribution;
import org.gradle.tooling.composite.internal.dist.VersionBasedGradleDistribution;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.util.CollectionUtils;

public class DefaultCompositeBuildConnector
extends CompositeBuildConnector {
    private final AsyncConsumerActionExecutor connection;
    private final ConnectionParameters parameters;
    private final Set<DefaultCompositeParticipant> participants = Sets.newHashSet();

    public DefaultCompositeBuildConnector(AsyncConsumerActionExecutor connection, ConnectionParameters parameters) {
        this.connection = connection;
        this.parameters = parameters;
    }

    @Override
    public CompositeParticipant addParticipant(File rootProjectDirectory) {
        DefaultCompositeParticipant participant = new DefaultCompositeParticipant(rootProjectDirectory);
        this.participants.add(participant);
        return participant;
    }

    @Override
    public CompositeBuildConnection connect() throws GradleConnectionException {
        Set<ProjectConnection> projectConnections = this.transformParticipantsToProjectConnections();
        DefaultCompositeBuildConnection actualConnection = new DefaultCompositeBuildConnection(this.connection, this.parameters, projectConnections);
        DeduplicatingCompositeBuildConnection deduplicatingConnection = new DeduplicatingCompositeBuildConnection(actualConnection);
        return deduplicatingConnection;
    }

    private Set<ProjectConnection> transformParticipantsToProjectConnections() {
        return CollectionUtils.collect(this.participants, (Transformer)new Transformer<ProjectConnection, DefaultCompositeParticipant>(){

            public ProjectConnection transform(DefaultCompositeParticipant participant) {
                GradleConnector gradleConnector = GradleConnector.newConnector().forProjectDirectory(participant.getRootProjectDirectory());
                DefaultCompositeBuildConnector.this.useGradleDistribution(gradleConnector, participant.getDistribution());
                return gradleConnector.connect();
            }
        });
    }

    private void useGradleDistribution(GradleConnector gradleConnector, GradleDistribution gradleDistribution) {
        if (gradleDistribution == null) {
            gradleConnector.useBuildDistribution();
        } else if (gradleDistribution instanceof InstalledGradleDistribution) {
            gradleConnector.useInstallation(((InstalledGradleDistribution)gradleDistribution).getGradleHome());
        } else if (gradleDistribution instanceof URILocatedGradleDistribution) {
            gradleConnector.useDistribution(((URILocatedGradleDistribution)gradleDistribution).getLocation());
        } else if (gradleDistribution instanceof VersionBasedGradleDistribution) {
            gradleConnector.useGradleVersion(((VersionBasedGradleDistribution)gradleDistribution).getGradleVersion());
        }
    }

    Set<DefaultCompositeParticipant> getParticipants() {
        return this.participants;
    }
}

