/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.progress.ToolingApiJob;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.SynchronizeGradleBuildOperation;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class SynchronizeGradleBuildsJob
extends ToolingApiJob {
    private final ImmutableSet<FixedRequestAttributes> builds;
    private final NewProjectHandler newProjectHandler;
    private final AsyncHandler initializer;

    public SynchronizeGradleBuildsJob(Set<FixedRequestAttributes> builds, NewProjectHandler newProjectHandler, AsyncHandler initializer) {
        super("Synchronize Gradle builds with workspace", true);
        this.builds = ImmutableSet.copyOf(builds);
        this.newProjectHandler = (NewProjectHandler)Preconditions.checkNotNull((Object)newProjectHandler);
        this.initializer = (AsyncHandler)Preconditions.checkNotNull((Object)initializer);
        this.setUser(true);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    @Override
    protected void runToolingApiJob(IProgressMonitor monitor) throws Exception {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.builds.size() + 1));
        this.initializer.run((IProgressMonitor)progress.newChild(1), this.getToken());
        for (FixedRequestAttributes build : this.builds) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.synchronizeBuild(build, progress);
        }
    }

    private void synchronizeBuild(FixedRequestAttributes build, SubMonitor progress) throws CoreException {
        progress.setTaskName(String.format("Synchronizing Gradle build at %s with workspace", build.getProjectDir()));
        progress.setWorkRemaining(2);
        ModelProvider modelProvider = CorePlugin.gradleWorkspaceManager().getGradleBuild(build).getModelProvider();
        OmniEclipseGradleBuild gradleBuild = modelProvider.fetchEclipseGradleBuild(FetchStrategy.FORCE_RELOAD, this.getToken(), (IProgressMonitor)progress.newChild(1));
        new SynchronizeGradleBuildOperation(gradleBuild, build, this.newProjectHandler).run((IProgressMonitor)progress.newChild(1));
    }

    public boolean shouldSchedule() {
        for (Job job : Job.getJobManager().find((Object)"org.eclipse.buildship.core.jobs")) {
            if (!(job instanceof SynchronizeGradleBuildsJob) || !this.isCoveredBy((SynchronizeGradleBuildsJob)job)) continue;
            return false;
        }
        return true;
    }

    private boolean isCoveredBy(SynchronizeGradleBuildsJob other) {
        return !(!Objects.equal(this.builds, other.builds) || this.newProjectHandler != NewProjectHandler.NO_OP && !Objects.equal((Object)this.newProjectHandler, (Object)other.newProjectHandler) || this.initializer != AsyncHandler.NO_OP && !Objects.equal((Object)this.initializer, (Object)other.initializer));
    }
}

