/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniAccessRule;
import com.gradleware.tooling.toolingmodel.OmniClasspathAttribute;
import com.gradleware.tooling.toolingmodel.OmniClasspathEntry;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniAccessRule;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniClasspathAttribute;
import com.gradleware.tooling.toolingmodel.repository.internal.compatibility.ForwardCompatibilityAccessRule;
import com.gradleware.tooling.toolingmodel.repository.internal.compatibility.ForwardCompatibilityClasspathEntry;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.eclipse.ClasspathAttribute;
import org.gradle.tooling.model.eclipse.EclipseClasspathEntry;

abstract class AbstractOmniClasspathEntry
implements OmniClasspathEntry {
    private final Optional<List<OmniClasspathAttribute>> classpathAttributes;
    private final Optional<List<OmniAccessRule>> accessRules;

    AbstractOmniClasspathEntry(Optional<List<OmniClasspathAttribute>> classpathAttributes, Optional<List<OmniAccessRule>> accessRules) {
        this.classpathAttributes = classpathAttributes;
        this.accessRules = accessRules;
    }

    @Override
    public Optional<List<OmniClasspathAttribute>> getClasspathAttributes() {
        return this.classpathAttributes;
    }

    @Override
    public Optional<List<OmniAccessRule>> getAccessRules() {
        return this.accessRules;
    }

    protected static Optional<List<OmniClasspathAttribute>> getClasspathAttributes(EclipseClasspathEntry entry) {
        DomainObjectSet attributes;
        try {
            attributes = entry.getClasspathAttributes();
        }
        catch (UnsupportedMethodException e) {
            return Optional.absent();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ClasspathAttribute attribute : attributes) {
            builder.add((Object)DefaultOmniClasspathAttribute.from(attribute));
        }
        return Optional.of((Object)builder.build());
    }

    protected static Optional<List<OmniClasspathAttribute>> getClasspathAttributes(ForwardCompatibilityClasspathEntry entry) {
        DomainObjectSet<? extends ClasspathAttribute> attributes;
        try {
            attributes = entry.getClasspathAttributes();
        }
        catch (UnsupportedMethodException e) {
            return Optional.absent();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ClasspathAttribute attribute : attributes) {
            builder.add((Object)DefaultOmniClasspathAttribute.from(attribute));
        }
        return Optional.of((Object)builder.build());
    }

    protected static Optional<List<OmniAccessRule>> getAccessRules(ForwardCompatibilityClasspathEntry entry) {
        DomainObjectSet<? extends ForwardCompatibilityAccessRule> accessRules;
        try {
            accessRules = entry.getAccessRules();
        }
        catch (UnsupportedMethodException e) {
            return Optional.absent();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ForwardCompatibilityAccessRule accessRule : accessRules) {
            builder.add((Object)DefaultOmniAccessRule.from(accessRule));
        }
        return Optional.of((Object)builder.build());
    }
}

