/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectNature;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.workspace.internal.StringSetProjectProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

final class ProjectNatureUpdater {
    private static final String PROJECT_PROPERTY_KEY_GRADLE_NATURES = "GRADLE_NATURES";
    private final IProject project;
    private final ImmutableList<OmniEclipseProjectNature> natures;

    public ProjectNatureUpdater(IProject project, List<OmniEclipseProjectNature> natures) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.natures = ImmutableList.copyOf(natures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNatures(IProgressMonitor monitor) {
        monitor.beginTask("Updating project natures", 2);
        try {
            StringSetProjectProperty knownNatures = StringSetProjectProperty.from(this.project, PROJECT_PROPERTY_KEY_GRADLE_NATURES);
            this.addNaturesNewInGradleModel(knownNatures, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.removeNaturesRemovedFromGradleModel(knownNatures, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            CorePlugin.logger().error(String.format("Cannot update project natures on %s.", this.project.getName()), e);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNaturesNewInGradleModel(StringSetProjectProperty knownNatures, IProgressMonitor monitor) {
        monitor.beginTask("Add new natures", this.natures.size());
        try {
            for (OmniEclipseProjectNature nature : this.natures) {
                String natureId = nature.getId();
                CorePlugin.workspaceOperations().addNature(this.project, natureId, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                knownNatures.add(natureId);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNaturesRemovedFromGradleModel(StringSetProjectProperty knownNatures, IProgressMonitor monitor) throws CoreException {
        Set<String> knownNatureIds = knownNatures.get();
        monitor.beginTask("Remove old natures", knownNatureIds.size());
        try {
            for (String knownNatureId : knownNatureIds) {
                if (!this.natureIdExistsInGradleModel(knownNatureId)) {
                    CorePlugin.workspaceOperations().removeNature(this.project, knownNatureId, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    knownNatures.remove(knownNatureId);
                    continue;
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean natureIdExistsInGradleModel(final String natureId) {
        return FluentIterable.from(this.natures).firstMatch((Predicate)new Predicate<OmniEclipseProjectNature>(){

            public boolean apply(OmniEclipseProjectNature nature) {
                return nature.getId().equals(natureId);
            }
        }).isPresent();
    }

    public static void update(IProject project, Optional<List<OmniEclipseProjectNature>> projectNatures, IProgressMonitor monitor) throws CoreException {
        List natures = (List)projectNatures.or(Collections.emptyList());
        ProjectNatureUpdater updater = new ProjectNatureUpdater(project, natures);
        updater.updateNatures(monitor);
    }
}

