/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.execution;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.core.internal.console.ProcessDescription;
import org.eclipse.buildship.ui.internal.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.internal.util.nodeselection.SelectionSpecificAction;
import org.eclipse.buildship.ui.internal.view.execution.ExecutionPage;
import org.eclipse.buildship.ui.internal.view.execution.ExecutionViewMessages;
import org.eclipse.buildship.ui.internal.view.execution.OpenTestSourceFileJob;
import org.eclipse.buildship.ui.internal.view.execution.OperationItem;
import org.eclipse.jface.action.Action;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;

public final class OpenTestSourceFileAction
extends Action
implements SelectionSpecificAction {
    private final ExecutionPage executionPage;

    public OpenTestSourceFileAction(ExecutionPage executionPage) {
        super(ExecutionViewMessages.Action_OpenTestSourceFile_Text);
        this.executionPage = executionPage;
    }

    public void run() {
        ProcessDescription processDescription = this.executionPage.getProcessDescription();
        ImmutableList<OperationItem> selectedTestOperationItems = this.executionPage.getSelection().toList(OperationItem.class);
        OpenTestSourceFileJob openTestSourceFileJob = new OpenTestSourceFileJob((List<OperationItem>)selectedTestOperationItems, processDescription.getRunConfig());
        openTestSourceFileJob.schedule();
    }

    @Override
    public boolean isVisibleFor(NodeSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        if (!selection.hasAllNodesOfType(OperationItem.class)) {
            return false;
        }
        ImmutableList<OperationItem> operationItems = selection.toList(OperationItem.class);
        return FluentIterable.from(operationItems).allMatch((Predicate)new Predicate<OperationItem>(this){

            public boolean apply(OperationItem operationItem) {
                OperationDescriptor adapter = (OperationDescriptor)operationItem.getAdapter(OperationDescriptor.class);
                return adapter instanceof JvmTestOperationDescriptor;
            }
        });
    }

    @Override
    public boolean isEnabledFor(NodeSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        if (!selection.hasAllNodesOfType(OperationItem.class)) {
            return false;
        }
        ImmutableList<OperationItem> operationItems = selection.toList(OperationItem.class);
        return FluentIterable.from(operationItems).allMatch((Predicate)new Predicate<OperationItem>(this){

            public boolean apply(OperationItem operationItem) {
                OperationDescriptor adapter = (OperationDescriptor)operationItem.getAdapter(OperationDescriptor.class);
                return adapter instanceof JvmTestOperationDescriptor && ((JvmTestOperationDescriptor)adapter).getClassName() != null;
            }
        });
    }

    @Override
    public void setEnabledFor(NodeSelection selection) {
        this.setEnabled(this.isEnabledFor(selection));
    }
}

