/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskViewState;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public final class TaskNodeViewerFilter
extends ViewerFilter {
    private final Predicate<TaskNode> predicate;

    private TaskNodeViewerFilter(Predicate<TaskNode> predicate) {
        this.predicate = predicate;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof TaskNode) {
            TaskNode taskNode = (TaskNode)element;
            return this.predicate.apply((Object)taskNode);
        }
        return true;
    }

    public static ViewerFilter createFor(TaskViewState state) {
        Predicate<TaskNode> predicate = TaskNodeViewerFilter.createCompositeFilter(state);
        return new TaskNodeViewerFilter(predicate);
    }

    private static Predicate<TaskNode> createCompositeFilter(final TaskViewState state) {
        Predicate<TaskNode> projectTasks = new Predicate<TaskNode>(){

            public boolean apply(TaskNode taskNode) {
                return state.isProjectTasksVisible() && taskNode.getType() == TaskNode.TaskNodeType.PROJECT_TASK_NODE;
            }
        };
        Predicate<TaskNode> taskSelectors = new Predicate<TaskNode>(){

            public boolean apply(TaskNode taskNode) {
                return state.isTaskSelectorsVisible() && taskNode.getType() == TaskNode.TaskNodeType.TASK_SELECTOR_NODE;
            }
        };
        Predicate<TaskNode> privateTasks = new Predicate<TaskNode>(){

            public boolean apply(TaskNode taskNode) {
                return state.isPrivateTasksVisible() || taskNode.isPublic();
            }
        };
        return Predicates.and((Predicate)Predicates.or((Predicate)projectTasks, (Predicate)taskSelectors), (Predicate)privateTasks);
    }
}

