/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.workspace.WorkspaceOperations;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubMonitor;

public final class DefaultWorkspaceOperations
implements WorkspaceOperations {
    private static final QualifiedName BUILD_FOLDER_PROPERTY_KEY = new QualifiedName("org.eclipse.buildship.core", "buildFolder");
    private static final QualifiedName SUB_PROJECT_PROPERTY_KEY = new QualifiedName("org.eclipse.buildship.core", "subProject");
    private static final String PROPERTY_TRUE = "true";

    @Override
    public ImmutableList<IProject> getAllProjects() {
        return ImmutableList.copyOf((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
    }

    @Override
    public Optional<IProject> findProjectByName(final String name) {
        return FluentIterable.from(this.getAllProjects()).firstMatch((Predicate)new Predicate<IProject>(){

            public boolean apply(IProject project) {
                return project.getName().equals(name);
            }
        });
    }

    @Override
    public Optional<IProject> findProjectByLocation(final File directory) {
        return FluentIterable.from(this.getAllProjects()).firstMatch((Predicate)new Predicate<IProject>(){

            public boolean apply(IProject project) {
                IPath location = project.getLocation();
                return location != null && location.toFile().equals(directory);
            }
        });
    }

    @Override
    public Optional<IProjectDescription> findProjectDescriptor(File location, IProgressMonitor monitor) {
        IPath descriptorLocation = Path.fromOSString((String)location.getPath()).append(".project");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            IProjectDescription projectDescription = workspace.loadProjectDescription(descriptorLocation);
            return Optional.of((Object)projectDescription);
        }
        catch (CoreException e) {
            return Optional.absent();
        }
    }

    @Override
    public void deleteProjectDescriptors(File location) {
        new File(location, ".project").delete();
        new File(location, ".classpath").delete();
    }

    @Override
    public IProject createProject(String name, File location, List<String> natureIds, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull(natureIds);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Project name must not be empty.");
        Preconditions.checkArgument((boolean)location.isDirectory(), (Object)String.format("Project location %s must be a directory.", location));
        Preconditions.checkState((!this.findProjectByName(name).isPresent() ? 1 : 0) != 0, (Object)String.format("Workspace already contains a project with name %s.", name));
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            String projectName = this.normalizeProjectName(name, location);
            IPath projectLocation = this.normalizeProjectLocation(location);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription projectDescription = workspace.newProjectDescription(projectName);
            projectDescription.setLocation(projectLocation);
            projectDescription.setComment(String.format("Project %s created by Buildship.", projectName));
            IProject project = workspace.getRoot().getProject(projectName);
            project.create(projectDescription, (IProgressMonitor)progress.newChild(1));
            project.open(128, (IProgressMonitor)progress.newChild(1));
            SubMonitor natureProgress = progress.newChild(1).setWorkRemaining(natureIds.size());
            for (String natureId : natureIds) {
                this.addNature(project, natureId, (IProgressMonitor)natureProgress.newChild(1));
            }
            return project;
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(e);
        }
    }

    @Override
    public IProject includeProject(IProjectDescription projectDescription, List<String> extraNatureIds, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)projectDescription);
        Preconditions.checkNotNull(extraNatureIds);
        String projectName = projectDescription.getName();
        Preconditions.checkState((!this.findProjectByName(projectName).isPresent() ? 1 : 0) != 0, (Object)String.format("Workspace already contains a project with name %s.", projectName));
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(projectName);
            project.create(projectDescription, (IProgressMonitor)progress.newChild(1));
            project.open(128, (IProgressMonitor)progress.newChild(1));
            SubMonitor natureProgress = progress.newChild(1).setWorkRemaining(extraNatureIds.size());
            for (String natureId : extraNatureIds) {
                this.addNature(project, natureId, (IProgressMonitor)natureProgress.newChild(1));
            }
            IProject iProject = project;
            return iProject;
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void refreshProject(IProject project, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)project.isAccessible(), (Object)"Project must be open.");
        try {
            project.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(e);
        }
    }

    @Override
    public String normalizeProjectName(String desiredName, File location) {
        Preconditions.checkNotNull((Object)desiredName);
        Preconditions.checkNotNull((Object)location);
        return this.isDirectChildOfWorkspaceRootFolder(location) ? location.getName() : desiredName;
    }

    private IPath normalizeProjectLocation(File location) {
        return this.isDirectChildOfWorkspaceRootFolder(location) ? null : Path.fromOSString((String)location.getPath());
    }

    private boolean isDirectChildOfWorkspaceRootFolder(File location) {
        IPath locationPath;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath rootLocationPath = workspace.getRoot().getLocation();
        return rootLocationPath.equals((Object)(locationPath = Path.fromOSString((String)location.getPath()))) || rootLocationPath.equals((Object)locationPath.removeLastSegments(1));
    }

    @Override
    public void addNature(IProject project, String natureId, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            IProjectDescription description = project.getDescription();
            ImmutableList currentNatureIds = ImmutableList.copyOf((Object[])description.getNatureIds());
            if (currentNatureIds.contains(natureId) || !this.natureRecognizedByEclipse(natureId)) {
                return;
            }
            ImmutableList newIds = ImmutableList.builder().addAll((Iterable)currentNatureIds).add((Object)natureId).build();
            description.setNatureIds((String[])newIds.toArray((Object[])new String[newIds.size()]));
            project.setDescription(description, (IProgressMonitor)progress.newChild(1));
        }
        catch (CoreException e) {
            String message = String.format("Cannot add nature %s to Eclipse project %s.", natureId, project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
    }

    private boolean natureRecognizedByEclipse(String natureId) {
        return ResourcesPlugin.getWorkspace().getNatureDescriptor(natureId) != null;
    }

    @Override
    public void removeNature(IProject project, String natureId, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            IProjectDescription description = project.getDescription();
            ImmutableList currentNatureIds = ImmutableList.copyOf((Object[])description.getNatureIds());
            if (!currentNatureIds.contains(natureId)) {
                return;
            }
            ArrayList newIds = new ArrayList(currentNatureIds);
            newIds.remove(natureId);
            description.setNatureIds(newIds.toArray(new String[newIds.size()]));
            project.setDescription(description, (IProgressMonitor)progress.newChild(1));
        }
        catch (CoreException e) {
            String message = String.format("Cannot remove nature %s from Eclipse project %s.", natureId, project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
    }

    @Override
    public void addBuildCommand(IProject project, String name, Map<String, String> arguments, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            IProjectDescription description = project.getDescription();
            ArrayList buildCommands = Lists.newArrayList((Object[])description.getBuildSpec());
            for (int i = 0; i < buildCommands.size(); ++i) {
                ICommand buildCommand = (ICommand)buildCommands.get(i);
                if (!buildCommand.getBuilderName().equals(name)) continue;
                if (buildCommand.getArguments().equals(arguments)) {
                    return;
                }
                buildCommands.set(i, this.createCommand(description, name, arguments));
                this.setNewBuildCommands(project, description, buildCommands, (IProgressMonitor)progress.newChild(1));
                return;
            }
            buildCommands.add(this.createCommand(description, name, arguments));
            this.setNewBuildCommands(project, description, buildCommands, (IProgressMonitor)progress.newChild(1));
        }
        catch (CoreException e) {
            String message = String.format("Cannot add build command %s with arguments %s to Eclipse project %s.", name, arguments, project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
    }

    private ICommand createCommand(IProjectDescription description, String name, Map<String, String> arguments) {
        ICommand command = description.newCommand();
        command.setBuilderName(name);
        command.setArguments((Map)ImmutableMap.copyOf(arguments));
        return command;
    }

    private void setNewBuildCommands(IProject project, IProjectDescription description, List<ICommand> buildCommands, IProgressMonitor monitor) throws CoreException {
        description.setBuildSpec(buildCommands.toArray(new ICommand[buildCommands.size()]));
        project.setDescription(description, monitor);
    }

    @Override
    public void removeBuildCommand(IProject project, final String name, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            IProjectDescription description = project.getDescription();
            ImmutableList existingCommands = ImmutableList.copyOf((Object[])description.getBuildSpec());
            ImmutableList updatedCommands = FluentIterable.from((Iterable)existingCommands).filter((Predicate)new Predicate<ICommand>(){

                public boolean apply(ICommand command) {
                    return !command.getBuilderName().equals(name);
                }
            }).toList();
            SubMonitor updateProgress = progress.newChild(1);
            if (existingCommands.size() != updatedCommands.size()) {
                description.setBuildSpec((ICommand[])updatedCommands.toArray((Object[])new ICommand[updatedCommands.size()]));
                project.setDescription(description, (IProgressMonitor)updateProgress);
            }
        }
        catch (CoreException e) {
            String message = String.format("Cannot remove build command %s from Eclipse project %s.", name, project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
    }

    @Override
    public void markAsBuildFolder(IFolder folder) {
        try {
            folder.setPersistentProperty(BUILD_FOLDER_PROPERTY_KEY, PROPERTY_TRUE);
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Could not mark folder %s as a build folder.", folder.getFullPath()), e);
        }
    }

    @Override
    public boolean isBuildFolder(IFolder folder) {
        try {
            return folder.exists() && PROPERTY_TRUE.equals(folder.getPersistentProperty(BUILD_FOLDER_PROPERTY_KEY));
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Could not check whether folder %s is a build folder.", folder.getFullPath()), e);
        }
    }

    @Override
    public void markAsSubProject(IFolder folder) {
        try {
            folder.setPersistentProperty(SUB_PROJECT_PROPERTY_KEY, PROPERTY_TRUE);
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Could not mark folder %s as a sub project.", folder.getFullPath()), e);
        }
    }

    @Override
    public boolean isSubProject(IFolder folder) {
        try {
            return folder.exists() && PROPERTY_TRUE.equals(folder.getPersistentProperty(SUB_PROJECT_PROPERTY_KEY));
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Could not check whether folder %s is a sub project.", folder.getFullPath()), e);
        }
    }

    @Override
    public IProject renameProject(IProject project, String newName, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkNotNull((Object)newName);
        Preconditions.checkArgument((boolean)project.isAccessible(), (Object)"Project must be open.");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (project.getName().equals(newName)) {
            return project;
        }
        IPath location = project.getLocation();
        if (location != null && this.isDirectChildOfWorkspaceRootFolder(location.toFile())) {
            throw new GradlePluginsRuntimeException(String.format("Project %s cannot be renamed, because it is in the default location.", project.getName()));
        }
        if (this.findProjectByName(newName).isPresent()) {
            throw new GradlePluginsRuntimeException(String.format("Workspace already contains a project with name %s.", newName));
        }
        try {
            IProjectDescription description = project.getDescription();
            description.setName(newName);
            project.move(description, false, (IProgressMonitor)progress.newChild(1));
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(e);
        }
        return (IProject)this.findProjectByName(newName).get();
    }
}

