/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

final class StringSetPersistentProperty {
    private final QualifiedName key;
    private final IResource resource;

    private StringSetPersistentProperty(QualifiedName key, IResource resource) {
        this.key = (QualifiedName)Preconditions.checkNotNull((Object)key);
        this.resource = (IResource)Preconditions.checkNotNull((Object)resource);
    }

    public void add(String entry) {
        ImmutableSet updated = ImmutableSet.builder().addAll(this.get()).add((Object)entry).build();
        this.set((Set<String>)updated);
    }

    public void remove(String entry) {
        Set<String> current = this.get();
        HashSet<String> updated = new HashSet<String>(current);
        updated.remove(entry);
        this.set(updated);
    }

    public Set<String> get() {
        try {
            String valueString = (String)Optional.fromNullable((Object)this.resource.getPersistentProperty(this.key)).or((Object)"");
            return ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)valueString));
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException((Exception)((Object)e));
        }
    }

    private void set(Set<String> entries) {
        try {
            String updateString = Joiner.on((char)',').join(entries);
            this.resource.setPersistentProperty(this.key, updateString);
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException((Exception)((Object)e));
        }
    }

    public static StringSetPersistentProperty from(QualifiedName key, IResource resource) {
        return new StringSetPersistentProperty(key, resource);
    }
}

