/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingutils.distribution;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.gradleware.tooling.toolingutils.ImmutableCollection;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublishedGradleVersions {
    private static final String VERSIONS_URL = "https://services.gradle.org/versions/all";
    private static final String MINIMUM_SUPPORTED_GRADLE_VERSION = "1.0";
    private static final String VERSION = "version";
    private static final String SNAPSHOT = "snapshot";
    private static final String ACTIVE_RC = "activeRc";
    private static final String RC_FOR = "rcFor";
    private static final String BROKEN = "broken";
    private static final Logger LOG = LoggerFactory.getLogger(PublishedGradleVersions.class);
    private final List<Map<String, String>> versions;

    private PublishedGradleVersions(List<Map<String, String>> versions) {
        this.versions = ImmutableList.copyOf(versions);
    }

    @ImmutableCollection
    public List<GradleVersion> getVersions() {
        return FluentIterable.from(this.versions).filter((Predicate)new Predicate<Map<String, String>>(){

            public boolean apply(Map<String, String> input) {
                return (Boolean.valueOf(input.get(PublishedGradleVersions.ACTIVE_RC)) != false || input.get(PublishedGradleVersions.RC_FOR).equals("")) && Boolean.valueOf(input.get(PublishedGradleVersions.BROKEN)) == false && Boolean.valueOf(input.get(PublishedGradleVersions.SNAPSHOT)) == false;
            }
        }).transform((Function)new Function<Map<String, String>, GradleVersion>(){

            public GradleVersion apply(Map<String, String> input) {
                return GradleVersion.version((String)input.get(PublishedGradleVersions.VERSION));
            }
        }).filter((Predicate)new Predicate<GradleVersion>(){

            public boolean apply(GradleVersion input) {
                return input.compareTo(GradleVersion.version((String)PublishedGradleVersions.MINIMUM_SUPPORTED_GRADLE_VERSION)) >= 0;
            }
        }).toList();
    }

    public static PublishedGradleVersions create(boolean enableCaching) {
        if (enableCaching) {
            File cacheFile = PublishedGradleVersions.getCacheFile();
            if (cacheFile.isFile() && cacheFile.exists()) {
                String json;
                Optional<String> cachedVersions = PublishedGradleVersions.readCacheVersionsFile(cacheFile);
                if (cacheFile.lastModified() > System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L)) {
                    LOG.info("Gradle version information cache file is not out-of-date. No remote download required.");
                    if (cachedVersions.isPresent()) {
                        return PublishedGradleVersions.create((String)cachedVersions.get());
                    }
                    LOG.error("Cannot read found Gradle version information cache file. Remote download required.");
                    String json2 = PublishedGradleVersions.downloadVersionInformation();
                    PublishedGradleVersions.storeCacheVersionsFile(json2, cacheFile);
                    return PublishedGradleVersions.create(json2);
                }
                LOG.info("Gradle version information cache file is out-of-date. Remote download required.");
                try {
                    json = PublishedGradleVersions.downloadVersionInformation();
                }
                catch (RuntimeException e) {
                    if (cachedVersions.isPresent()) {
                        return PublishedGradleVersions.create((String)cachedVersions.get());
                    }
                    throw new RuntimeException("Cannot collect Gradle version information remotely nor locally.", e);
                }
                PublishedGradleVersions.storeCacheVersionsFile(json, cacheFile);
                return PublishedGradleVersions.create(json);
            }
            LOG.info("Gradle version information cache file is not available. Remote download required.");
            String json = PublishedGradleVersions.downloadVersionInformation();
            PublishedGradleVersions.storeCacheVersionsFile(json, cacheFile);
            return PublishedGradleVersions.create(json);
        }
        String json = PublishedGradleVersions.downloadVersionInformation();
        return PublishedGradleVersions.create(json);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String downloadVersionInformation() {
        String string;
        HttpURLConnection connection = null;
        InputStreamReader reader = null;
        try {
            URL url = PublishedGradleVersions.createURL(VERSIONS_URL);
            connection = (HttpURLConnection)url.openConnection();
            reader = new InputStreamReader(connection.getInputStream(), Charsets.UTF_8);
            string = CharStreams.toString((Readable)reader);
        }
        catch (IOException e) {
            try {
                LOG.error("Cannot download published Gradle versions.", (Throwable)e);
                throw new RuntimeException("Cannot download published Gradle versions.", e);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(reader, (boolean)false);
                }
                catch (IOException e2) {
                    LOG.error("Can't close stream after downloading published Gradle versions", (Throwable)e2);
                }
                if (connection != null) {
                    connection.disconnect();
                }
                throw throwable;
            }
        }
        try {
            Closeables.close((Closeable)reader, (boolean)false);
        }
        catch (IOException e) {
            LOG.error("Can't close stream after downloading published Gradle versions", (Throwable)e);
        }
        if (connection != null) {
            connection.disconnect();
        }
        return string;
    }

    private static void storeCacheVersionsFile(String json, File cacheFile) {
        cacheFile.getParentFile().mkdirs();
        try {
            CharSource.wrap((CharSequence)json).copyTo(Files.asCharSink((File)cacheFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]));
        }
        catch (IOException e) {
            LOG.error("Cannot write Gradle version information cache file.", (Throwable)e);
        }
    }

    private static Optional<String> readCacheVersionsFile(File cacheFile) {
        try {
            return Optional.of((Object)Files.toString((File)cacheFile, (Charset)Charsets.UTF_8));
        }
        catch (IOException e) {
            LOG.error("Cannot read found Gradle version information cache file.", (Throwable)e);
            return Optional.absent();
        }
    }

    public static PublishedGradleVersions create(String json) {
        Gson gson = new GsonBuilder().create();
        TypeToken<List<Map<String, String>>> typeToken = new TypeToken<List<Map<String, String>>>(){};
        List versions = (List)gson.fromJson(json, typeToken.getType());
        return new PublishedGradleVersions(versions);
    }

    private static URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
    }

    private static File getCacheFile() {
        return new File(System.getProperty("user.home"), ".tooling/gradle/versions.json");
    }
}

