/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.util.object.MoreObjects;
import org.eclipse.buildship.core.workspace.WorkspaceOperations;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public final class DefaultWorkspaceOperations
implements WorkspaceOperations {
    @Override
    public ImmutableList<IProject> getAllProjects() {
        return ImmutableList.copyOf((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
    }

    @Override
    public Optional<IProject> findProjectByName(final String name) {
        return FluentIterable.from(this.getAllProjects()).firstMatch((Predicate)new Predicate<IProject>(){

            public boolean apply(IProject project) {
                return project.getName().equals(name);
            }
        });
    }

    @Override
    public Optional<IProject> findProjectByLocation(final File directory) {
        return FluentIterable.from(this.getAllProjects()).firstMatch((Predicate)new Predicate<IProject>(){

            public boolean apply(IProject project) {
                IPath location = project.getLocation();
                return location != null && location.toFile().equals(directory);
            }
        });
    }

    @Override
    public Optional<IProjectDescription> findProjectInFolder(File location, IProgressMonitor monitor) {
        if (location == null || !location.exists()) {
            return Optional.absent();
        }
        File dotProjectFile = new File(location, ".project");
        if (!dotProjectFile.exists() || !dotProjectFile.isFile()) {
            return Optional.absent();
        }
        try {
            IPath projectLocation = this.resolveProjectLocation(location);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            FileInputStream dotProjectStream = new FileInputStream(dotProjectFile);
            IProjectDescription projectDescription = workspace.loadProjectDescription((InputStream)dotProjectStream);
            projectDescription.setLocation(projectLocation);
            return Optional.of((Object)projectDescription);
        }
        catch (Exception e) {
            String message = String.format("Cannot open existing Eclipse project from %s.", dotProjectFile.getAbsolutePath());
            throw new GradlePluginsRuntimeException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteAllProjects(IProgressMonitor monitor) {
        monitor = (IProgressMonitor)MoreObjects.firstNonNull(monitor, new NullProgressMonitor());
        monitor.beginTask("Delete all Eclipse projects from workspace", 100);
        try {
            ImmutableList<IProject> allProjects = this.getAllProjects();
            for (IProject project : allProjects) {
                try {
                    project.delete(false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 100 / allProjects.size()));
                }
                catch (Exception e) {
                    String message = String.format("Cannot delete project %s.", project.getName());
                    throw new GradlePluginsRuntimeException(message, e);
                    return;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void deleteProjectDescriptors(File location) {
        new File(location, ".project").delete();
        new File(location, ".classpath").delete();
    }

    @Override
    public IProject createProject(String name, File location, List<String> natureIds, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull(natureIds);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Project name must not be empty.");
        Preconditions.checkArgument((boolean)location.exists(), (Object)String.format("Project location %s must exist.", location));
        Preconditions.checkArgument((boolean)location.isDirectory(), (Object)String.format("Project location %s must be a directory.", location));
        monitor = (IProgressMonitor)MoreObjects.firstNonNull(monitor, new NullProgressMonitor());
        monitor.beginTask(String.format("Create Eclipse project %s", name), 3 + natureIds.size());
        try {
            Preconditions.checkState((!this.findProjectByName(name).isPresent() ? 1 : 0) != 0, (Object)String.format("Workspace already contains a project with name %s.", name));
            String projectName = this.resolveProjectName(name, location);
            IPath projectLocation = this.resolveProjectLocation(location);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription projectDescription = workspace.newProjectDescription(projectName);
            projectDescription.setLocation(projectLocation);
            projectDescription.setComment(String.format("Project %s created by Buildship.", projectName));
            IProject project = workspace.getRoot().getProject(projectName);
            project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            for (String natureId : natureIds) {
                this.addNature(project, natureId, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            IProject iProject = project;
            return iProject;
        }
        catch (Exception e) {
            String message = String.format("Cannot create Eclipse project %s.", name);
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IProject includeProject(IProjectDescription projectDescription, List<String> extraNatureIds, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)projectDescription);
        Preconditions.checkNotNull(extraNatureIds);
        String projectName = projectDescription.getName();
        monitor = (IProgressMonitor)MoreObjects.firstNonNull(monitor, new NullProgressMonitor());
        monitor.beginTask(String.format("Include existing non-workspace Eclipse project %s", projectName), 3 + extraNatureIds.size());
        try {
            Preconditions.checkState((!this.findProjectByName(projectName).isPresent() ? 1 : 0) != 0, (Object)String.format("Workspace already contains a project with name %s.", projectName));
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(projectName);
            project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            for (String natureId : extraNatureIds) {
                this.addNature(project, natureId, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            IProject iProject = project;
            return iProject;
        }
        catch (Exception e) {
            String message = String.format("Cannot include existing Eclipse project %s.", projectName);
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IJavaProject createJavaProject(IProject project, IPath jrePath, IClasspathEntry classpathContainer, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkNotNull((Object)jrePath);
        Preconditions.checkArgument((boolean)project.isAccessible(), (Object)"Project must be open.");
        monitor = (IProgressMonitor)MoreObjects.firstNonNull(monitor, new NullProgressMonitor());
        monitor.beginTask(String.format("Create Eclipse Java project %s", project.getName()), 17);
        try {
            this.addNature(project, "org.eclipse.jdt.core.javanature", (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            IJavaProject javaProject = JavaCore.create((IProject)project);
            monitor.worked(5);
            this.setClasspathOnProject(javaProject, jrePath, classpathContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            IFolder outputFolder = this.createOutputFolder(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            javaProject.setOutputLocation(outputFolder.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            javaProject.save((IProgressMonitor)new SubProgressMonitor(monitor, 2), true);
            IJavaProject iJavaProject = javaProject;
            return iJavaProject;
        }
        catch (Exception e) {
            String message = String.format("Cannot create Eclipse Java project %s.", project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    private IFolder createOutputFolder(IProject project, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Create output folder for Eclipse project %s", project.getName()), 1);
        try {
            IFolder outputFolder = project.getFolder("bin");
            if (!outputFolder.exists()) {
                outputFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            IFolder iFolder = outputFolder;
            return iFolder;
        }
        catch (Exception e) {
            String message = String.format("Cannot create output folder for Eclipse project %s.", project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    private void setClasspathOnProject(IJavaProject javaProject, IPath jrePath, IClasspathEntry classpathContainerEntry, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Configure sources and classpath for Eclipse project %s", javaProject.getProject().getName()), 10);
        try {
            ImmutableList.Builder entries = ImmutableList.builder();
            entries.add((Object)JavaCore.newContainerEntry((IPath)jrePath));
            monitor.worked(1);
            entries.add((Object)classpathContainerEntry);
            monitor.worked(1);
            ImmutableList entriesArray = entries.build();
            javaProject.setRawClasspath(entriesArray.toArray(new IClasspathEntry[entriesArray.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 6));
        }
        catch (Exception e) {
            String message = String.format("Cannot configure sources and classpath for Eclipse project %s.", javaProject.getProject().getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void refreshProject(IProject project, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)project.isAccessible(), (Object)"Project must be open.");
        monitor = (IProgressMonitor)MoreObjects.firstNonNull(monitor, new NullProgressMonitor());
        monitor.beginTask(String.format("Refresh Eclipse project %s", project.getName()), 1);
        try {
            project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Exception e) {
            String message = String.format("Cannot refresh Eclipse project %s.", project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    private String resolveProjectName(String nameInGradleModel, File location) {
        return this.isDirectChildOfWorkspaceRootFolder(location) ? location.getName() : nameInGradleModel;
    }

    private IPath resolveProjectLocation(File location) {
        return this.isDirectChildOfWorkspaceRootFolder(location) ? null : Path.fromOSString((String)location.getPath());
    }

    private boolean isDirectChildOfWorkspaceRootFolder(File location) {
        IPath locationPath;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath rootLocationPath = workspace.getRoot().getLocation();
        return rootLocationPath.equals((Object)(locationPath = Path.fromOSString((String)location.getPath()))) || rootLocationPath.equals((Object)locationPath.removeLastSegments(1));
    }

    @Override
    public void addNature(IProject project, String natureId, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Add nature %s to Eclipse project %s", natureId, project.getName()), 1);
        try {
            IProjectDescription description = project.getDescription();
            ImmutableList currentNatureIds = ImmutableList.copyOf((Object[])description.getNatureIds());
            if (currentNatureIds.contains(natureId) || !this.natureRecognizedByEclipse(natureId)) {
                return;
            }
            ImmutableList newIds = ImmutableList.builder().addAll((Iterable)currentNatureIds).add((Object)natureId).build();
            description.setNatureIds((String[])newIds.toArray((Object[])new String[newIds.size()]));
            project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            String message = String.format("Cannot add nature %s to Eclipse project %s.", natureId, project.getName());
            throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
        }
        finally {
            monitor.done();
        }
    }

    private boolean natureRecognizedByEclipse(String natureId) {
        return ResourcesPlugin.getWorkspace().getNatureDescriptor(natureId) != null;
    }

    @Override
    public void removeNature(IProject project, String natureId, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Remove nature %s from Eclipse project %s", natureId, project.getName()), 1);
        try {
            IProjectDescription description = project.getDescription();
            ImmutableList currentNatureIds = ImmutableList.copyOf((Object[])description.getNatureIds());
            if (!currentNatureIds.contains(natureId)) {
                return;
            }
            ArrayList newIds = new ArrayList(currentNatureIds);
            newIds.remove(natureId);
            description.setNatureIds(newIds.toArray(new String[newIds.size()]));
            project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            String message = String.format("Cannot remove nature %s from Eclipse project %s.", natureId, project.getName());
            throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void addBuildCommand(IProject project, String name, Map<String, String> arguments, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Add build command %s to Eclipse project %s", name, project.getName()), 1);
        try {
            IProjectDescription description = project.getDescription();
            ArrayList buildCommands = Lists.newArrayList((Object[])description.getBuildSpec());
            for (int i = 0; i < buildCommands.size(); ++i) {
                ICommand buildCommand = (ICommand)buildCommands.get(i);
                if (!buildCommand.getBuilderName().equals(name)) continue;
                if (buildCommand.getArguments().equals(arguments)) {
                    return;
                }
                buildCommands.set(i, this.createCommand(description, name, arguments));
                this.setNewBuildCommands(project, description, buildCommands, new SubProgressMonitor(monitor, 1));
                return;
            }
            buildCommands.add(this.createCommand(description, name, arguments));
            this.setNewBuildCommands(project, description, buildCommands, new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            String message = String.format("Cannot add build command %s with arguments %s to Eclipse project %s.", name, arguments, project.getName());
            throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
        }
        finally {
            monitor.done();
        }
    }

    private ICommand createCommand(IProjectDescription description, String name, Map<String, String> arguments) {
        ICommand command = description.newCommand();
        command.setBuilderName(name);
        command.setArguments((Map)ImmutableMap.copyOf(arguments));
        return command;
    }

    private void setNewBuildCommands(IProject project, IProjectDescription description, List<ICommand> buildCommands, SubProgressMonitor monitor) throws CoreException {
        description.setBuildSpec(buildCommands.toArray(new ICommand[buildCommands.size()]));
        project.setDescription(description, (IProgressMonitor)monitor);
    }

    @Override
    public void removeBuildCommand(IProject project, final String name, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Remove build command %s from Eclipse project %s", name, project.getName()), 1);
        try {
            IProjectDescription description = project.getDescription();
            ImmutableList existingCommands = ImmutableList.copyOf((Object[])description.getBuildSpec());
            ImmutableList updatedCommands = FluentIterable.from((Iterable)existingCommands).filter((Predicate)new Predicate<ICommand>(){

                public boolean apply(ICommand command) {
                    return !command.getBuilderName().equals(name);
                }
            }).toList();
            if (existingCommands.size() != updatedCommands.size()) {
                description.setBuildSpec((ICommand[])updatedCommands.toArray((Object[])new ICommand[updatedCommands.size()]));
                project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
        }
        catch (CoreException e) {
            String message = String.format("Cannot remove build command %s from Eclipse project %s.", name, project.getName());
            throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
        }
        finally {
            monitor.done();
        }
    }
}

