/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.gradleware.tooling.toolingmodel.OmniClasspathEntry;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectDependency;
import com.gradleware.tooling.toolingmodel.OmniExternalDependency;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.buildship.core.util.classpath.ClasspathUtils;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.buildship.core.workspace.internal.PersistentModelBuilder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

final class GradleClasspathContainerUpdater {
    private final IJavaProject eclipseProject;
    private final OmniEclipseProject gradleProject;
    private final Map<File, OmniEclipseProject> projectDirToProject;

    private GradleClasspathContainerUpdater(IJavaProject eclipseProject, OmniEclipseProject gradleProject, Set<OmniEclipseProject> allGradleProjects) {
        this.eclipseProject = (IJavaProject)Preconditions.checkNotNull((Object)eclipseProject);
        this.gradleProject = (OmniEclipseProject)Preconditions.checkNotNull((Object)gradleProject);
        this.projectDirToProject = Maps.newHashMap();
        for (OmniEclipseProject project : gradleProject.getRoot().getAll()) {
            this.projectDirToProject.put(project.getProjectDirectory(), project);
        }
    }

    private void updateClasspathContainer(PersistentModelBuilder persistentModel, IProgressMonitor monitor) throws JavaModelException {
        ImmutableList<IClasspathEntry> containerEntries = this.collectClasspathContainerEntries();
        GradleClasspathContainerUpdater.setClasspathContainer(this.eclipseProject, containerEntries, monitor);
        persistentModel.classpath((List<IClasspathEntry>)containerEntries);
    }

    private ImmutableList<IClasspathEntry> collectClasspathContainerEntries() {
        List<IClasspathEntry> externalDependencies = this.collectExternalDependencies();
        List<IClasspathEntry> projectDependencies = this.collectProjectDependencies();
        boolean hasExportedEntry = FluentIterable.from(externalDependencies).anyMatch((Predicate)new Predicate<IClasspathEntry>(){

            public boolean apply(IClasspathEntry entry) {
                return entry.isExported();
            }
        });
        if (hasExportedEntry) {
            return ImmutableList.builder().addAll(externalDependencies).addAll(projectDependencies).build();
        }
        return ImmutableList.builder().addAll(projectDependencies).addAll(externalDependencies).build();
    }

    private List<IClasspathEntry> collectExternalDependencies() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (OmniExternalDependency dependency : this.gradleProject.getExternalDependencies()) {
            File dependencyFile = dependency.getFile();
            boolean linkedResourceCreated = this.tryCreatingLinkedResource(dependencyFile, (ImmutableList.Builder<IClasspathEntry>)result);
            if (linkedResourceCreated) continue;
            String dependencyName = dependencyFile.getName();
            if (!dependencyFile.isDirectory() && !dependencyName.endsWith(".jar") && !dependencyName.endsWith(".zip")) continue;
            IPath path = Path.fromOSString((String)dependencyFile.getAbsolutePath());
            File dependencySource = dependency.getSource();
            IPath sourcePath = dependencySource != null ? Path.fromOSString((String)dependencySource.getAbsolutePath()) : null;
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, (IPath)sourcePath, null, (IAccessRule[])ClasspathUtils.createAccessRules((OmniClasspathEntry)dependency), (IClasspathAttribute[])ClasspathUtils.createClasspathAttributes((OmniClasspathEntry)dependency), (boolean)dependency.isExported());
            result.add((Object)entry);
        }
        return result.build();
    }

    private boolean tryCreatingLinkedResource(File dependencyFile, ImmutableList.Builder<IClasspathEntry> result) {
        if (!dependencyFile.exists()) {
            Path path = new Path("/" + dependencyFile.getPath());
            IResource member = this.eclipseProject.getProject().findMember((IPath)path);
            if (member != null) {
                IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)member.getFullPath(), null, null);
                result.add((Object)entry);
                return true;
            }
        }
        return false;
    }

    private List<IClasspathEntry> collectProjectDependencies() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (OmniEclipseProjectDependency dependency : this.gradleProject.getProjectDependencies()) {
            Path path = new Path("/" + dependency.getPath());
            IClasspathEntry entry = JavaCore.newProjectEntry((IPath)path, (IAccessRule[])ClasspathUtils.createAccessRules((OmniClasspathEntry)dependency), (boolean)true, (IClasspathAttribute[])ClasspathUtils.createClasspathAttributes((OmniClasspathEntry)dependency), (boolean)dependency.isExported());
            result.add((Object)entry);
        }
        return result.build();
    }

    public static void updateFromModel(IJavaProject eclipseProject, OmniEclipseProject gradleProject, Set<OmniEclipseProject> allGradleProjects, PersistentModelBuilder persistentModel, IProgressMonitor monitor) throws JavaModelException {
        GradleClasspathContainerUpdater updater = new GradleClasspathContainerUpdater(eclipseProject, gradleProject, allGradleProjects);
        updater.updateClasspathContainer(persistentModel, monitor);
    }

    public static boolean updateFromStorage(IJavaProject eclipseProject, IProgressMonitor monitor) throws JavaModelException {
        PersistentModel model = CorePlugin.modelPersistence().loadModel(eclipseProject.getProject());
        if (model.isPresent()) {
            GradleClasspathContainerUpdater.setClasspathContainer(eclipseProject, model.getClasspath(), monitor);
            return true;
        }
        return false;
    }

    public static void clear(IJavaProject eclipseProject, IProgressMonitor monitor) throws JavaModelException {
        GradleClasspathContainerUpdater.setClasspathContainer(eclipseProject, (List<IClasspathEntry>)ImmutableList.of(), monitor);
    }

    private static void setClasspathContainer(IJavaProject eclipseProject, List<IClasspathEntry> classpathEntries, IProgressMonitor monitor) throws JavaModelException {
        IClasspathContainer classpathContainer = GradleClasspathContainer.newInstance(classpathEntries);
        JavaCore.setClasspathContainer((IPath)GradleClasspathContainer.CONTAINER_PATH, (IJavaProject[])new IJavaProject[]{eclipseProject}, (IClasspathContainer[])new IClasspathContainer[]{classpathContainer}, (IProgressMonitor)monitor);
    }
}

