/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.projectimport;

import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingutils.binding.Property;
import com.gradleware.tooling.toolingutils.binding.Validator;
import com.gradleware.tooling.toolingutils.binding.Validators;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.util.collections.CollectionsUtils;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;

public final class ProjectImportConfiguration {
    private final Property<File> projectDir;
    private final Property<GradleDistributionWrapper> gradleDistribution;
    private final Property<File> gradleUserHome;
    private final Property<File> javaHome;
    private final Property<String> jvmArguments;
    private final Property<String> arguments;
    private final Property<Boolean> applyWorkingSets;
    private final Property<List<String>> workingSets;

    public ProjectImportConfiguration() {
        this((Validator<File>)Validators.noOp(), (Validator<GradleDistributionWrapper>)Validators.noOp(), (Validator<File>)Validators.noOp(), (Validator<File>)Validators.noOp(), (Validator<String>)Validators.noOp(), (Validator<String>)Validators.noOp(), (Validator<Boolean>)Validators.noOp(), (Validator<List<String>>)Validators.noOp());
    }

    public ProjectImportConfiguration(Validator<File> projectDirValidator, Validator<GradleDistributionWrapper> gradleDistributionValidator, Validator<File> gradleUserHomeValidator, Validator<File> javaHomeValidator, Validator<String> jvmArgumentsValidator, Validator<String> argumentsValidator, Validator<Boolean> applyWorkingSetsValidator, Validator<List<String>> workingSetsValidators) {
        this.projectDir = Property.create(projectDirValidator);
        this.gradleDistribution = Property.create(gradleDistributionValidator);
        this.gradleUserHome = Property.create(gradleUserHomeValidator);
        this.javaHome = Property.create(javaHomeValidator);
        this.jvmArguments = Property.create(jvmArgumentsValidator);
        this.arguments = Property.create(argumentsValidator);
        this.applyWorkingSets = Property.create(applyWorkingSetsValidator);
        this.workingSets = Property.create(workingSetsValidators);
    }

    public Property<File> getProjectDir() {
        return this.projectDir;
    }

    public void setProjectDir(File projectDir) {
        this.projectDir.setValue((Object)projectDir);
    }

    public Property<GradleDistributionWrapper> getGradleDistribution() {
        return this.gradleDistribution;
    }

    public void setGradleDistribution(GradleDistributionWrapper gradleDistribution) {
        this.gradleDistribution.setValue((Object)gradleDistribution);
    }

    public Property<File> getGradleUserHome() {
        return this.gradleUserHome;
    }

    public void setGradleUserHome(File gradleUserHome) {
        this.gradleUserHome.setValue((Object)gradleUserHome);
    }

    public Property<File> getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(File javaHome) {
        this.javaHome.setValue((Object)javaHome);
    }

    public Property<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public void setJvmArguments(String jvmArguments) {
        this.jvmArguments.setValue((Object)jvmArguments);
    }

    public Property<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments.setValue((Object)arguments);
    }

    public Property<Boolean> getApplyWorkingSets() {
        return this.applyWorkingSets;
    }

    public void setApplyWorkingSets(Boolean applyWorkingSets) {
        this.applyWorkingSets.setValue((Object)applyWorkingSets);
    }

    public Property<List<String>> getWorkingSets() {
        return this.workingSets;
    }

    public void setWorkingSets(List<String> workingSets) {
        this.workingSets.setValue(workingSets);
    }

    public FixedRequestAttributes toFixedAttributes() {
        File projectDir = (File)this.getProjectDir().getValue();
        GradleDistribution gradleDistribution = ((GradleDistributionWrapper)this.getGradleDistribution().getValue()).toGradleDistribution();
        File gradleUserHome = (File)this.getGradleUserHome().getValue();
        File javaHome = (File)this.getJavaHome().getValue();
        ImmutableList<String> jvmArguments = CollectionsUtils.splitBySpace((String)this.getJvmArguments().getValue());
        ImmutableList<String> arguments = CollectionsUtils.splitBySpace((String)this.getArguments().getValue());
        return new FixedRequestAttributes(projectDir, gradleUserHome, gradleDistribution, javaHome, jvmArguments, arguments);
    }
}

