/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.GradleProjectNatureConfiguredEvent;
import org.eclipse.buildship.core.configuration.GradleProjectNatureDeconfiguredEvent;
import org.eclipse.buildship.core.event.Event;
import org.eclipse.buildship.core.event.EventListener;
import org.eclipse.buildship.core.launch.ExternalLaunchConfigurationManager;
import org.eclipse.buildship.core.launch.internal.SupportedLaunchConfigType;
import org.eclipse.buildship.core.workspace.ProjectCreatedEvent;
import org.eclipse.buildship.core.workspace.ProjectDeletedEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;

public final class DefaultExternalLaunchConfigurationManager
implements ExternalLaunchConfigurationManager {
    private static final String ORIGINAL_CLASSPATH_PROVIDER_ATTRIBUTE = "org.eclipse.buildship.core.originalclasspathprovider";
    private final LaunchConfigurationListener launchConfigurationListener = new LaunchConfigurationListener();

    private DefaultExternalLaunchConfigurationManager() {
    }

    public static DefaultExternalLaunchConfigurationManager createAndRegister() {
        DefaultExternalLaunchConfigurationManager manager = new DefaultExternalLaunchConfigurationManager();
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)manager.launchConfigurationListener);
        CorePlugin.listenerRegistry().addEventListener(manager.launchConfigurationListener);
        return manager;
    }

    public void unregister() {
        CorePlugin.listenerRegistry().removeEventListener(this.launchConfigurationListener);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this.launchConfigurationListener);
    }

    @Override
    public void updateClasspathProviders(IProject project) {
        try {
            ILaunchManager configManager = DebugPlugin.getDefault().getLaunchManager();
            for (SupportedLaunchConfigType supportedType : SupportedLaunchConfigType.values()) {
                ILaunchConfigurationType type = configManager.getLaunchConfigurationType(supportedType.getId());
                for (ILaunchConfiguration config : configManager.getLaunchConfigurations(type)) {
                    if (!DefaultExternalLaunchConfigurationManager.hasProject(config, project)) continue;
                    this.updateClasspathProvider(config);
                }
            }
        }
        catch (CoreException e) {
            CorePlugin.logger().warn("Cannot update classpath provider", e);
        }
    }

    private static boolean hasProject(ILaunchConfiguration configuration, IProject project) throws CoreException {
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
        return project.getName().equals(projectName);
    }

    @Override
    public void updateClasspathProvider(ILaunchConfiguration configuration) {
        try {
            if (!SupportedLaunchConfigType.isSupported(configuration)) {
                return;
            }
            boolean isGradleProject = this.isGradleProject(configuration);
            boolean hasGradleClasspathProvider = this.hasGradleClasspathProvider(configuration);
            if (isGradleProject && !hasGradleClasspathProvider) {
                this.addGradleClasspathProvider(configuration);
            } else if (!isGradleProject && hasGradleClasspathProvider) {
                this.removeGradleClasspathProvider(configuration);
            }
        }
        catch (CoreException e) {
            CorePlugin.logger().warn("Cannot update classpath provider", e);
        }
    }

    private boolean isGradleProject(ILaunchConfiguration configuration) {
        IJavaProject javaProject = this.getJavaProject(configuration);
        return javaProject != null && GradleProjectNature.isPresentOn(javaProject.getProject());
    }

    private IJavaProject getJavaProject(ILaunchConfiguration configuration) {
        try {
            return JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        }
        catch (CoreException e) {
            return null;
        }
    }

    private boolean hasGradleClasspathProvider(ILaunchConfiguration configuration) throws CoreException {
        return "org.eclipse.buildship.core.classpathprovider".equals(configuration.getAttributes().get(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER));
    }

    private void addGradleClasspathProvider(ILaunchConfiguration configuration) throws CoreException {
        String originalClasspathProvider = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, (String)null);
        HashMap plusEntries = Maps.newHashMap();
        plusEntries.put(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.buildship.core.classpathprovider");
        if (originalClasspathProvider != null) {
            plusEntries.put(ORIGINAL_CLASSPATH_PROVIDER_ATTRIBUTE, originalClasspathProvider);
        }
        this.updateLaunchConfiguration(configuration, (Map<String, String>)plusEntries, Collections.emptySet());
    }

    private void removeGradleClasspathProvider(ILaunchConfiguration configuration) throws CoreException {
        String originalClasspathProvider = configuration.getAttribute(ORIGINAL_CLASSPATH_PROVIDER_ATTRIBUTE, (String)null);
        HashMap plusEntries = Maps.newHashMap();
        HashSet minusEntries = Sets.newHashSet();
        if (originalClasspathProvider != null) {
            plusEntries.put(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, originalClasspathProvider);
            minusEntries.add(ORIGINAL_CLASSPATH_PROVIDER_ATTRIBUTE);
        } else {
            minusEntries.add(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER);
        }
        this.updateLaunchConfiguration(configuration, (Map<String, String>)plusEntries, (Set<String>)minusEntries);
    }

    private void updateLaunchConfiguration(ILaunchConfiguration configuration, Map<String, String> plusEntries, Set<String> minusEntries) throws CoreException {
        if (configuration instanceof ILaunchConfigurationWorkingCopy) {
            this.updateLaunchConfiguration((ILaunchConfigurationWorkingCopy)configuration, plusEntries, minusEntries);
        } else {
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            this.updateLaunchConfiguration(workingCopy, plusEntries, minusEntries);
            workingCopy.doSave();
        }
    }

    private void updateLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration, Map<String, String> plusEntries, Set<String> minusEntries) {
        for (String key : plusEntries.keySet()) {
            configuration.setAttribute(key, plusEntries.get(key));
        }
        for (String key : minusEntries) {
            configuration.removeAttribute(key);
        }
    }

    private class LaunchConfigurationListener
    implements ILaunchConfigurationListener,
    EventListener {
        private boolean configChangeCalled;

        private LaunchConfigurationListener() {
        }

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            DefaultExternalLaunchConfigurationManager.this.updateClasspathProvider(configuration);
        }

        public synchronized void launchConfigurationChanged(ILaunchConfiguration configuration) {
            if (this.configChangeCalled) {
                return;
            }
            try {
                this.configChangeCalled = true;
                DefaultExternalLaunchConfigurationManager.this.updateClasspathProvider(configuration);
            }
            finally {
                this.configChangeCalled = false;
            }
        }

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        }

        @Override
        public void onEvent(Event event) {
            if (event instanceof GradleProjectNatureConfiguredEvent) {
                DefaultExternalLaunchConfigurationManager.this.updateClasspathProviders(((GradleProjectNatureConfiguredEvent)event).getProject());
            } else if (event instanceof GradleProjectNatureDeconfiguredEvent) {
                DefaultExternalLaunchConfigurationManager.this.updateClasspathProviders(((GradleProjectNatureDeconfiguredEvent)event).getProject());
            } else if (event instanceof ProjectCreatedEvent) {
                DefaultExternalLaunchConfigurationManager.this.updateClasspathProviders(((ProjectCreatedEvent)event).getProject());
            } else if (event instanceof ProjectDeletedEvent) {
                DefaultExternalLaunchConfigurationManager.this.updateClasspathProviders(((ProjectDeletedEvent)event).getProject());
            }
        }
    }
}

