/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.List;
import org.eclipse.buildship.core.internal.util.binding.Property;
import org.eclipse.buildship.core.internal.util.binding.ValidationListener;
import org.eclipse.buildship.ui.internal.util.font.FontUtils;
import org.eclipse.buildship.ui.internal.util.widget.UiBuilder;
import org.eclipse.buildship.ui.internal.wizard.project.GradleProjectWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.HelpContextIdProvider;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWizardPage
extends WizardPage {
    private final ProjectImportConfiguration configuration;
    private final List<Property<?>> observedProperties;
    private final String defaultMessage;
    private final Font defaultFont;
    private final UiBuilder.UiBuilderFactory builderFactory;

    protected AbstractWizardPage(String name, String title, String defaultMessage, ProjectImportConfiguration configuration, final List<Property<?>> observedProperties) {
        super(name);
        this.configuration = configuration;
        this.observedProperties = observedProperties;
        this.defaultMessage = defaultMessage;
        this.setTitle(title);
        this.setMessage(defaultMessage);
        this.setImageDescriptor(ImageDescriptor.createFromFile(GradleProjectWizardPage.class, (String)"/icons/full/wizban/wizard.png"));
        this.defaultFont = FontUtils.getDefaultDialogFont();
        this.builderFactory = new UiBuilder.UiBuilderFactory(this.defaultFont);
        ValidationListener listener = new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                if (validationErrorMessage.isPresent()) {
                    AbstractWizardPage.this.setMessage((String)validationErrorMessage.get(), 3);
                } else {
                    Optional<String> otherErrorMessage = this.validateAllObservedProperties();
                    if (!otherErrorMessage.isPresent()) {
                        AbstractWizardPage.this.setMessage(AbstractWizardPage.this.defaultMessage);
                    } else {
                        AbstractWizardPage.this.setMessage((String)otherErrorMessage.get(), 3);
                    }
                }
                AbstractWizardPage.this.setPageComplete(AbstractWizardPage.this.isPageComplete());
            }

            private Optional<String> validateAllObservedProperties() {
                for (Property property : observedProperties) {
                    Optional errorMessage = property.validate();
                    if (!errorMessage.isPresent()) continue;
                    return errorMessage;
                }
                return Optional.absent();
            }
        };
        for (Property<?> property : observedProperties) {
            property.addValidationListener(listener);
        }
    }

    protected ProjectImportConfiguration getConfiguration() {
        return this.configuration;
    }

    protected UiBuilder.UiBuilderFactory getUiBuilderFactory() {
        return this.builderFactory;
    }

    public final void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite pageControl = this.createWizardPageContent(parent);
        this.setControl((Control)pageControl);
    }

    private Composite createWizardPageContent(Composite parent) {
        ScrolledComposite externalRoot = new ScrolledComposite(parent, 768);
        externalRoot.setExpandHorizontal(true);
        externalRoot.setExpandVertical(true);
        externalRoot.setMinSize(new Point(230, 380));
        Composite container = new Composite((Composite)externalRoot, 0);
        this.createWidgets(container);
        String contextInformation = Strings.emptyToNull((String)this.getPageContextInformation());
        if (contextInformation != null) {
            this.createWidgetsForContextInformation(container, contextInformation);
        }
        Point containerSize = container.computeSize(-1, -1);
        container.setSize(containerSize);
        externalRoot.setContent((Control)container);
        return externalRoot;
    }

    protected abstract void createWidgets(Composite var1);

    private void createWidgetsForContextInformation(Composite root, String contextInformation) {
        Composite contextInformationContainer = new Composite(root, 0);
        GridLayout contextInformationContainerLayout = new GridLayout(1, false);
        contextInformationContainerLayout.marginTop = 30;
        contextInformationContainerLayout.marginRight = 30;
        contextInformationContainerLayout.marginLeft = 30;
        contextInformationContainerLayout.verticalSpacing = 15;
        contextInformationContainer.setLayout((Layout)contextInformationContainerLayout);
        contextInformationContainer.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        Label separator = new Label(contextInformationContainer, 258);
        separator.setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite textContainer = new Composite(contextInformationContainer, 0);
        textContainer.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout textContainerLayout = new GridLayout(1, false);
        textContainerLayout.marginRight = 50;
        textContainerLayout.marginLeft = 50;
        textContainer.setLayout((Layout)textContainerLayout);
        StyledText contextInformationText = new StyledText(textContainer, 16777282);
        contextInformationText.setText(contextInformation);
        contextInformationText.setBackground(contextInformationText.getParent().getBackground());
        contextInformationText.setEnabled(false);
        contextInformationText.setEditable(false);
        GridData contextInformationTextLayoutData = new GridData(0x1000000, 0x1000000, true, false, 1, 1);
        contextInformationTextLayoutData.widthHint = 400;
        contextInformationText.setLayoutData((Object)contextInformationTextLayoutData);
    }

    protected abstract String getPageContextInformation();

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.getWizard() instanceof HelpContextIdProvider) {
            String helpContextId = ((HelpContextIdProvider)this.getWizard()).getHelpContextId();
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), helpContextId);
        }
    }

    public boolean isPageComplete() {
        for (Property<?> property : this.observedProperties) {
            if (property.isValid()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        this.defaultFont.dispose();
        super.dispose();
    }
}

