/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.handlers.attachment;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.model.helpers.graph.InvolvementHierarchyGraph;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.Path;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.Paths;

public class GraphHelper {
    public static Collection<Path> getShortestPathTowards(InvolvementHierarchyGraph graph, FunctionalChainInvolvement fci, FunctionalChainInvolvement expected) {
        Collection<InvolvementHierarchyGraph.Element> nodes = GraphHelper.getVertices(graph, fci);
        Collection<InvolvementHierarchyGraph.Element> nextValids = GraphHelper.getNextValids(nodes, n -> GraphHelper.getInvolvment(n).equals(expected));
        Paths paths = new Paths();
        nextValids.stream().forEach(v -> paths.addPath((InvolvementHierarchyGraph.Element)v, Path.of(v)));
        LinkedList<InvolvementHierarchyGraph.Element> toVisit = new LinkedList<InvolvementHierarchyGraph.Element>(GraphHelper.getPrevious(nextValids));
        while (!toVisit.isEmpty()) {
            InvolvementHierarchyGraph.Element node = toVisit.removeFirst();
            if (paths.containsKey(node)) continue;
            for (InvolvementHierarchyGraph.Element next : GraphHelper.getNexts(Arrays.asList(node))) {
                paths.getPaths(next).stream().forEach(path -> paths.addPath(node, Path.combine(node, path)));
            }
            if (nodes.contains(node)) break;
            toVisit.addAll(GraphHelper.getPrevious(node));
        }
        return nodes.stream().map(x -> paths.getPaths((InvolvementHierarchyGraph.Element)x)).flatMap(x -> x.stream()).collect(Collectors.toList());
    }

    public static FunctionalChainInvolvement getInvolvment(InvolvementHierarchyGraph.Element e) {
        if (e instanceof InvolvementHierarchyGraph.Edge) {
            return ((InvolvementHierarchyGraph.Edge)e).getLink();
        }
        return ((InvolvementHierarchyGraph.Vertex)e).getFunction();
    }

    public static Collection<InvolvementHierarchyGraph.Element> getPrevious(InvolvementHierarchyGraph.Element e) {
        return GraphHelper.getPrevious(Arrays.asList(e));
    }

    public static Collection<InvolvementHierarchyGraph.Element> getPrevious(Collection<InvolvementHierarchyGraph.Element> elements) {
        return elements.stream().map(x -> {
            if (x instanceof InvolvementHierarchyGraph.Edge) {
                return Arrays.asList(((InvolvementHierarchyGraph.Edge)x).getSource());
            }
            return ((InvolvementHierarchyGraph.Vertex)x).getIncomingEdges();
        }).flatMap(x -> x.stream()).collect(Collectors.toList());
    }

    public static Collection<InvolvementHierarchyGraph.Element> getNexts(InvolvementHierarchyGraph.Element e) {
        return GraphHelper.getNexts(Arrays.asList(e));
    }

    public static Collection<InvolvementHierarchyGraph.Element> getNexts(Collection<InvolvementHierarchyGraph.Element> elements) {
        return elements.stream().map(x -> {
            if (x instanceof InvolvementHierarchyGraph.Edge) {
                return Arrays.asList(((InvolvementHierarchyGraph.Edge)x).getTarget());
            }
            return ((InvolvementHierarchyGraph.Vertex)x).getOutgoingEdges();
        }).flatMap(x -> x.stream()).collect(Collectors.toList());
    }

    public static Collection<InvolvementHierarchyGraph.Element> getVertices(InvolvementHierarchyGraph graph, FunctionalChainInvolvement fci) {
        return graph.getVertices().keySet().stream().filter(v -> v.getFunction() == fci).map(v -> (InvolvementHierarchyGraph.Element)graph.getVertices().get(v)).collect(Collectors.toList());
    }

    public static Collection<InvolvementHierarchyGraph.Element> getNextValids(Collection<InvolvementHierarchyGraph.Element> nodes, Function<InvolvementHierarchyGraph.Element, Boolean> isValid) {
        LinkedHashSet<InvolvementHierarchyGraph.Element> result = new LinkedHashSet<InvolvementHierarchyGraph.Element>();
        LinkedList<InvolvementHierarchyGraph.Element> toVisit = new LinkedList<InvolvementHierarchyGraph.Element>(GraphHelper.getNexts(nodes));
        HashSet<InvolvementHierarchyGraph.Element> visited = new HashSet<InvolvementHierarchyGraph.Element>();
        while (!toVisit.isEmpty()) {
            InvolvementHierarchyGraph.Element node = toVisit.removeFirst();
            if (visited.contains(node)) continue;
            if (isValid.apply(node).booleanValue()) {
                result.add(node);
            } else {
                toVisit.addAll(GraphHelper.getNexts(Arrays.asList(node)));
            }
            visited.add(node);
        }
        return result;
    }
}

