/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.provider;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.provider.ModelElementItemPropertyDescriptor;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.vp.ms.CSConfiguration;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class ChildConfigurationsPropertyDescriptor
extends ModelElementItemPropertyDescriptor {
    public ChildConfigurationsPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, boolean multiLine, boolean sortChoices, Object staticImage, String category, String[] filterFlags) {
        super(adapterFactory, resourceLocator, displayName, description, feature, isSettable, multiLine, sortChoices, staticImage, category, filterFlags);
    }

    private Collection<CSConfiguration> getOwnedConfigurations(ExtensibleElement e, Predicate<CSConfiguration> predicate) {
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        for (EObject ext : e.getOwnedExtensions()) {
            if (!(ext instanceof CSConfiguration) || !predicate.apply((Object)((CSConfiguration)ext))) continue;
            result.add((CSConfiguration)ext);
        }
        return result;
    }

    private Collection<CSConfiguration> getOwnedConfigurations(ExtensibleElement e) {
        return this.getOwnedConfigurations(e, (Predicate<CSConfiguration>)Predicates.alwaysTrue());
    }

    private Collection<CSConfiguration> getSiblingConfigurations(ExtensibleElement parent, CSConfiguration configuration) {
        return this.getOwnedConfigurations(parent, (Predicate<CSConfiguration>)Predicates.not((Predicate)Predicates.equalTo((Object)configuration)));
    }

    protected Collection<?> getComboBoxObjects(Object object) {
        Component parent = (Component)((CSConfiguration)object).eContainer();
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        result.addAll(this.getSiblingConfigurations((ExtensibleElement)parent, (CSConfiguration)object));
        if (parent instanceof LogicalComponent) {
            ArrayDeque<LogicalComponent> toVisit = new ArrayDeque<LogicalComponent>((Collection<LogicalComponent>)((LogicalComponent)parent).getOwnedLogicalComponents());
            while (toVisit.size() > 0) {
                LogicalComponent c = (LogicalComponent)toVisit.pop();
                result.addAll(this.getOwnedConfigurations((ExtensibleElement)c));
                for (LogicalComponent child : c.getOwnedLogicalComponents()) {
                    toVisit.push(child);
                }
            }
        } else if (parent instanceof PhysicalComponent) {
            ArrayDeque<PhysicalComponent> toVisit = new ArrayDeque<PhysicalComponent>();
            toVisit.addAll((Collection<PhysicalComponent>)((PhysicalComponent)parent).getOwnedPhysicalComponents());
            toVisit.addAll((Collection<PhysicalComponent>)((PhysicalComponent)parent).getDeployedPhysicalComponents());
            HashSet<PhysicalComponent> seen = new HashSet<PhysicalComponent>();
            seen.add((PhysicalComponent)parent);
            this.walkPhysicalComponentHierarchy(result, toVisit, seen);
        }
        return result;
    }

    private void walkPhysicalComponentHierarchy(Collection<CSConfiguration> result, Deque<PhysicalComponent> toVisit, Set<PhysicalComponent> seen) {
        while (toVisit.size() > 0) {
            PhysicalComponent c = toVisit.pop();
            if (!seen.add(c)) continue;
            result.addAll(this.getOwnedConfigurations((ExtensibleElement)c));
            for (PhysicalComponent child : c.getOwnedPhysicalComponents()) {
                toVisit.push(child);
            }
            for (PhysicalComponent deployed : c.getDeployedPhysicalComponents()) {
                toVisit.push(deployed);
            }
        }
    }
}

