/*
 * Decompiled with CFR 0.152.
 */
package ms.design;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ms.design.AbstractDNodeScope;
import ms.design.AbstractMsRefreshExtension;
import ms.design.ConfigurationScopeVisitor;
import ms.design.Scope;
import ms.design.ScopeFactory;
import ms.design.ScopeVisitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.vp.ms.CSConfiguration;
import org.polarsys.capella.vp.ms.ui.css.CSSAdapter;

public class DefaultMsRefreshExtension
extends AbstractMsRefreshExtension {
    protected ScopeFactory createScopeFactory() {
        return new ScopeFactory();
    }

    protected ScopeVisitor<?> createVisitor() {
        return new ConfigurationScopeVisitor(){
            Map<DEdge, Scope> rememberedEdgeScopes = new HashMap<DEdge, Scope>();

            @Override
            public Collection<CSConfiguration> visitAbstracDNodeScope(AbstractDNodeScope asd) {
                Object result = super.visitAbstracDNodeScope(asd);
                AbstractDNode node = (AbstractDNode)asd.getElement();
                if (node instanceof EdgeTarget) {
                    for (DEdge edge : ((EdgeTarget)node).getOutgoingEdges()) {
                        this.updateEdgeStyle(asd, edge, true);
                    }
                    for (DEdge edge : ((EdgeTarget)node).getIncomingEdges()) {
                        this.updateEdgeStyle(asd, edge, false);
                    }
                }
                return result;
            }

            private Scope getOppositeScope(DEdge edge, Scope thisScope) {
                Scope otherEnd = this.rememberedEdgeScopes.remove(edge);
                if (otherEnd == null) {
                    this.rememberedEdgeScopes.put(edge, thisScope);
                }
                return otherEnd;
            }

            private void updateEdgeStyle(AbstractDNodeScope thisScope, DEdge edge, boolean outgoing) {
                Scope opposite = this.getOppositeScope(edge, thisScope);
                if (opposite != null) {
                    Scope out;
                    Scope in = outgoing ? opposite : thisScope;
                    Scope scope = out = outgoing ? thisScope : opposite;
                    if (edge.getTarget() instanceof FunctionalExchange) {
                        this.updateFunctionalExchangeStyle(edge, (FunctionalExchange)edge.getTarget(), in, out);
                    } else if (edge.getTarget() instanceof ComponentExchange) {
                        this.updateComponentExchangeStyle(edge, (ComponentExchange)edge.getTarget(), in, out);
                    } else if (edge.getTarget() instanceof PhysicalLink) {
                        this.updatePhysicalLinkStyle(edge, (PhysicalLink)edge.getTarget(), in, out);
                    }
                }
            }

            private void updateFunctionalExchangeStyle(DEdge edge, FunctionalExchange fe, Scope fipScope, Scope fopScope) {
                this.updateExchangeStyle(edge, fipScope, (EObject)fe.getTargetFunctionInputPort(), fopScope, (EObject)fe.getSourceFunctionOutputPort());
            }

            private void updateComponentExchangeStyle(DEdge edge, ComponentExchange ce, Scope inScope, Scope outScope) {
                this.updateExchangeStyle(edge, inScope, (EObject)ce.getTargetPort(), outScope, (EObject)ce.getSourcePort());
            }

            private void updatePhysicalLinkStyle(DEdge edge, PhysicalLink pe, Scope inScope, Scope outScope) {
                this.updateExchangeStyle(edge, inScope, (EObject)pe.getTargetPhysicalPort(), outScope, (EObject)pe.getSourcePhysicalPort());
            }

            private void updateExchangeStyle(DEdge edge, Scope inScope, EObject inScopeTarget, Scope outScope, EObject outScopeTarget) {
                CSSAdapter style = CSSAdapter.getAdapter((EObject)edge).clear();
                ArrayList<CSConfiguration> applied = new ArrayList<CSConfiguration>(this.getAllScopeConfigurations(outScope));
                applied.retainAll(this.getAllScopeConfigurations(inScope));
                this.updateStyle(style, edge.getTarget(), applied);
            }
        };
    }

    protected void refreshNodes(DDiagram dDiagram) {
        ScopeFactory scopeFactory = this.createScopeFactory();
        ScopeVisitor<?> visitor = this.createVisitor();
        ArrayDeque<Scope> remaining = new ArrayDeque<Scope>();
        remaining.push((Scope)scopeFactory.doSwitch((EObject)dDiagram));
        while (!remaining.isEmpty()) {
            Scope scope = (Scope)remaining.pop();
            scope.accept(visitor);
            scopeFactory.setParent(scope);
            for (DDiagramElement dDiagramElement : scope.getChildren()) {
                Scope childScope = (Scope)scopeFactory.doSwitch((EObject)dDiagramElement);
                if (dDiagramElement instanceof DEdge) continue;
                remaining.push(childScope);
            }
        }
    }

    public void postRefresh(DDiagram dDiagram) {
        this.refreshNodes(dDiagram);
    }
}

