/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.ui;

import com.google.common.base.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.linkedtext.ui.DefaultLinkedTextContentProvider;
import org.polarsys.capella.common.linkedtext.ui.EmbeddedLinkedTextEditorConfiguration;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextCompletionProcessor;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextHyperlink;
import org.polarsys.capella.core.data.capellacommon.AbstractState;

public class EmbeddedSituationExpressionEditor {
    private SourceViewer sv;
    private LinkedTextDocument.Input _input;
    private LinkedTextDocument _document;
    private final String INITIAL_TEXT = "";

    public EmbeddedSituationExpressionEditor(Composite parent, int style) {
        this.sv = this.createSourceViewer(parent, style);
        this.sv.getTextWidget().addKeyListener((KeyListener)new InputKeyListener(this.sv));
        this.sv.getTextWidget().setAlwaysShowScrollBars(false);
        this.sv.getTextWidget().setToolTipText("");
    }

    protected Color getHintColor() {
        return this.sv.getTextWidget().getDisplay().getSystemColor(16);
    }

    public void setInput(LinkedTextDocument.Input input) {
        if (this._input != null) {
            throw new IllegalStateException("Reuse of EmbeddedLinkedTextEditor instances is not yet supported");
        }
        this._input = input;
        this._document = LinkedTextDocument.load((LinkedTextDocument.Input)this._input);
        this._document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                EmbeddedSituationExpressionEditor.this.sv.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String content = EmbeddedSituationExpressionEditor.this._document.saveToRaw();
                        EmbeddedSituationExpressionEditor.this._input.setText(content);
                    }
                });
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        this.sv.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EmbeddedSituationExpressionEditor.this._document != null) {
                    EmbeddedSituationExpressionEditor.this._document.dispose();
                }
            }
        });
        this.sv.setDocument((IDocument)this._document, (IAnnotationModel)new AnnotationModel());
        this.sv.invalidateTextPresentation();
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        return new EmbeddedLinkedTextEditorConfiguration(){

            public IContentAssistant getContentAssistant(final ISourceViewer sourceViewer) {
                ContentAssistant ca = new ContentAssistant();
                LinkedTextCompletionProcessor completionProcessor = new LinkedTextCompletionProcessor((IStructuredContentProvider)new DefaultLinkedTextContentProvider((Predicate)new Predicate<EObject>(){

                    public boolean apply(EObject arg) {
                        if (arg instanceof AbstractState) {
                            return EcoreUtil.isAncestor((EObject)((EObject)EmbeddedSituationExpressionEditor.this._input.getDocumentBase()), (EObject)arg);
                        }
                        return false;
                    }
                })){

                    private ICompletionProposal createProposal(final ICompletionProposal delegate) {
                        return new ICompletionProposal(){

                            public void apply(IDocument document) {
                                delegate.apply(document);
                            }

                            public Point getSelection(IDocument document) {
                                return delegate.getSelection(document);
                            }

                            public String getAdditionalProposalInfo() {
                                return delegate.getAdditionalProposalInfo();
                            }

                            public String getDisplayString() {
                                String[] elems = delegate.getDisplayString().split("/");
                                return String.valueOf(elems[elems.length - 3]) + "/" + elems[elems.length - 1];
                            }

                            public Image getImage() {
                                return delegate.getImage();
                            }

                            public IContextInformation getContextInformation() {
                                return delegate.getContextInformation();
                            }
                        };
                    }

                    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
                        ICompletionProposal[] result = null;
                        ICompletionProposal[] inner = super.computeCompletionProposals((ITextViewer)sourceViewer, offset);
                        if (inner != null) {
                            result = new ICompletionProposal[inner.length];
                            int i = 0;
                            while (i < inner.length) {
                                result[i] = this.createProposal(inner[i]);
                                ++i;
                            }
                        }
                        return result;
                    }
                };
                ca.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__dftl_partition_content_type");
                ca.setProposalPopupOrientation(10);
                ca.setContextInformationPopupOrientation(20);
                ca.addCompletionListener((ICompletionListener)completionProcessor);
                return ca;
            }
        };
    }

    protected SourceViewer createSourceViewer(Composite parent, int styles) {
        final SourceViewer viewer = new SourceViewer(parent, null, null, true, styles);
        viewer.configure(this.createSourceViewerConfiguration());
        viewer.appendVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                LinkedTextHyperlink hl;
                if (event.keyCode == 8) {
                    LinkedTextHyperlink hl2 = EmbeddedSituationExpressionEditor.this.getHyperlinkOverOrBeforeCaret(viewer);
                    if (hl2 != null) {
                        event.doit = false;
                        this.postDelete(hl2, event.display);
                    }
                } else if (event.keyCode == 127 && (hl = EmbeddedSituationExpressionEditor.this.getHyperlinkOverOrAfterCaret(viewer)) != null) {
                    event.doit = false;
                    this.postDelete(hl, event.display);
                }
            }

            private void postDelete(final LinkedTextHyperlink hl, Display display) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            viewer.getDocument().replace(hl.getOffset(), hl.getLength(), "");
                        }
                        catch (BadLocationException exception) {
                            exception.printStackTrace();
                        }
                        hl.delete();
                    }
                });
            }
        });
        viewer.getTextWidget().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                LinkedTextDocument doc = (LinkedTextDocument)viewer.getInput();
                for (LinkedTextHyperlink h : doc.getHyperlinks()) {
                    if (!h.overlapsWith(event.start, event.end - event.start) || event.start == event.end && h.getOffset() == event.start) continue;
                    event.doit = false;
                }
            }
        });
        return viewer;
    }

    private LinkedTextHyperlink getHyperlinkOverOrBeforeCaret(SourceViewer viewer) {
        LinkedTextDocument doc = (LinkedTextDocument)viewer.getInput();
        int caretOffset = viewer.getTextWidget().getCaretOffset();
        for (LinkedTextHyperlink h : doc.getHyperlinks()) {
            if (caretOffset <= h.getOffset() || caretOffset > h.getOffset() + h.getLength()) continue;
            return h;
        }
        return null;
    }

    private LinkedTextHyperlink getHyperlinkOverOrAfterCaret(SourceViewer viewer) {
        LinkedTextDocument doc = (LinkedTextDocument)viewer.getInput();
        int caretOffset = viewer.getTextWidget().getCaretOffset();
        for (LinkedTextHyperlink h : doc.getHyperlinks()) {
            if (caretOffset < h.getOffset() || caretOffset >= h.getOffset() + h.getLength()) continue;
            return h;
        }
        return null;
    }

    private LinkedTextHyperlink getHyperlinkOverCaret(SourceViewer viewer) {
        LinkedTextDocument doc = (LinkedTextDocument)viewer.getInput();
        int caretOffset = viewer.getTextWidget().getCaretOffset();
        for (LinkedTextHyperlink h : doc.getHyperlinks()) {
            if (caretOffset <= h.getOffset() || caretOffset >= h.getOffset() + h.getLength()) continue;
            return h;
        }
        return null;
    }

    public SourceViewer getSourceViewer() {
        return this.sv;
    }

    private class InputKeyListener
    implements KeyListener {
        final SourceViewer _sv;

        InputKeyListener(SourceViewer viewer) {
            this._sv = viewer;
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 32: {
                    if ((e.stateMask & 0x40000) != 262144 || EmbeddedSituationExpressionEditor.this.getHyperlinkOverCaret(this._sv) != null) break;
                    this._sv.doOperation(13);
                }
            }
        }
    }
}

