/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.ui;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.helpers.TransactionHelper;

public abstract class EMFCommandHandler
extends AbstractHandler {
    private Command command;
    private EditingDomain domain;

    protected void setBaseEnabled(boolean state) {
        super.setBaseEnabled(state);
        if (!state) {
            this.domain = null;
            this.command = null;
        }
    }

    protected boolean acceptSelectionElement(Object element, Object evaluationContext) {
        return element instanceof EObject;
    }

    protected <T> T adapt(Object element, Class<T> clazz) {
        EObject target;
        View view;
        if (clazz.isInstance(element)) {
            return (T)element;
        }
        if (element instanceof GraphicalEditPart && (element = (view = (View)((GraphicalEditPart)element).getModel()).getElement()) instanceof DSemanticDecorator && clazz.isInstance(target = ((DSemanticDecorator)element).getTarget())) {
            return (T)target;
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        Collection sel = (Collection)((IEvaluationContext)evaluationContext).getDefaultVariable();
        for (Object o : sel) {
            if (!this.acceptSelectionElement(o, evaluationContext)) {
                this.setBaseEnabled(false);
                return;
            }
            TransactionalEditingDomain csDomain = null;
            if (o instanceof EObject) {
                csDomain = TransactionHelper.getEditingDomain((EObject)((EObject)o));
            } else if (o instanceof GraphicalEditPart) {
                View view = (View)((GraphicalEditPart)o).getModel();
                csDomain = TransactionHelper.getEditingDomain((EObject)view.getElement());
            }
            if (csDomain == null) {
                this.setBaseEnabled(false);
                return;
            }
            if (this.domain == null) {
                this.domain = csDomain;
            }
            if (this.domain == csDomain) continue;
            this.setBaseEnabled(false);
            return;
        }
        this.command = this.createCommand(sel, evaluationContext);
        this.setBaseEnabled(this.command.canExecute());
    }

    protected abstract Command createCommand(Collection<?> var1, Object var2);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.domain.getCommandStack().execute(this.command);
        }
        finally {
            this.domain = null;
            this.command = null;
        }
        return null;
    }
}

