/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.Decomposition;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionContentProposalProvider;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionGeneralViewer;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionReuseContentProposal;
import org.polarsys.capella.core.ui.toolkit.decomposition.Messages;

public class DecompositionUtil {
    private DecompositionGeneralViewer _decompositionGeneralViewer;
    static final String ONCE_USED = Messages.getString("LCDecomp.interface.onceused");
    static final String UNUSED = Messages.getString("LCDecomp.interface.unused");
    static final String MULTIPLE_USED = Messages.getString("LCDecomp.interface.multipleused");
    static Image _onceUsedImage;
    static Image _unUsedImage;
    static Image _multipleUsedImage;
    private static Shell currentShell;
    private static Listener _renameDecompListener;
    public static final String INTERFACE_ONCE_ASSIGNED_ID = "ASSIGNED_ONCE";
    public static final String INTERFACE_UNASSIGNED_ID = "UNASSIGNED";
    public static final String INTERFACE_TWICE_ASSIGNED_ID = "ASSIGNED_TWICE";

    public DecompositionUtil(DecompositionGeneralViewer decompositionGeneralViewer) {
        this._decompositionGeneralViewer = decompositionGeneralViewer;
        try {
            ImageRegistry imgRegistry = this._decompositionGeneralViewer.getDecompositionModel().getImgRegistry();
            _onceUsedImage = imgRegistry.get(INTERFACE_ONCE_ASSIGNED_ID);
            _unUsedImage = imgRegistry.get(INTERFACE_UNASSIGNED_ID);
            _multipleUsedImage = imgRegistry.get(INTERFACE_TWICE_ASSIGNED_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initializeImages(ImageRegistry imageRegistry) {
        try {
            _onceUsedImage = imageRegistry.get(INTERFACE_ONCE_ASSIGNED_ID);
            _unUsedImage = imageRegistry.get(INTERFACE_UNASSIGNED_ID);
            _multipleUsedImage = imageRegistry.get(INTERFACE_TWICE_ASSIGNED_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getDecompositionName(List<Decomposition> list) {
        Object name = "";
        if (list.size() == 1) {
            return name;
        }
        List<Integer> tmpList = DecompositionUtil.parseDecompositionList(list);
        int index = tmpList.size();
        int i = 0;
        while (i < tmpList.size()) {
            int x = tmpList.get(i);
            if (x > i + 1) {
                index = i;
                break;
            }
            ++i;
        }
        name = Messages.getString("LCDecompGeneralViewer.decomposition.name") + (index + 1);
        return name;
    }

    private static List<Integer> parseDecompositionList(List<Decomposition> list) {
        ArrayList<Integer> tmp = new ArrayList<Integer>(1);
        for (Decomposition decomp : list) {
            if (decomp.getName().indexOf(Messages.getString("LCDecompGeneralViewer.decomposition.name")) == -1) continue;
            int lastIndex = decomp.getName().lastIndexOf(" ");
            Integer integ = Integer.valueOf(decomp.getName().substring(lastIndex + 1));
            if (integ == 0) continue;
            tmp.add(integ);
        }
        Collections.sort(tmp);
        return tmp;
    }

    public static String getTargetComponentName(List<DecompositionComponent> list) {
        Object name = "";
        List<Integer> tmpList = DecompositionUtil.parseTargetComponentsList(list);
        int index = tmpList.size();
        int i = 0;
        while (i < tmpList.size()) {
            if (tmpList.get(i) > i + 1) {
                index = i;
                break;
            }
            ++i;
        }
        name = Messages.getString("LCDecompGeneralViewer.targetcomponent.name") + (index + 1);
        return name;
    }

    private static List<Integer> parseTargetComponentsList(List<DecompositionComponent> list) {
        ArrayList<Integer> tmp = new ArrayList<Integer>(1);
        for (DecompositionComponent comp : list) {
            if (comp.getName().indexOf(Messages.getString("LCDecompGeneralViewer.targetcomponent.name")) == -1) continue;
            int lastIndex = comp.getName().lastIndexOf(" ");
            Integer integ = Integer.valueOf(comp.getName().substring(lastIndex + 1));
            tmp.add(integ);
        }
        Collections.sort(tmp);
        return tmp;
    }

    static Listener getRenameDecompListener(final CTabItem item) {
        if (_renameDecompListener != null) {
            item.removeListener(8, _renameDecompListener);
        }
        _renameDecompListener = new Listener(){

            public void handleEvent(Event event) {
                String newName = (String)event.data;
                Decomposition decomposition = (Decomposition)item.getData();
                if (decomposition.getDecompositionModel().renameDecomposition(decomposition, newName)) {
                    item.setText(newName);
                    TreeViewer vv = (TreeViewer)item.getData("TARGET_TREEVIEWER");
                    vv.setSelection(vv.getSelection());
                }
            }
        };
        return _renameDecompListener;
    }

    static Listener getLabelListener(final TreeViewer viewer) {
        Listener labelListener = new Listener(){
            Tree tree = null;

            public void handleEvent(Event event) {
                this.tree = viewer.getTree();
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData("_TREEITEM");
                        this.tree.setSelection(new TreeItem[]{(TreeItem)e.item});
                        this.tree.notifyListeners(13, e);
                        shell.dispose();
                        this.tree.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        return labelListener;
    }

    static Listener getTreeListener(final TreeViewer viewer, final Listener labelListener) {
        Listener treeListener = new Listener(){
            Shell tip = null;
            Label label = null;
            Tree tree = null;

            public void handleEvent(Event event) {
                this.tree = viewer.getTree();
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TreeItem item = this.tree.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(this.tree.getShell(), 540676);
                        this.tip.setBackground(Display.getCurrent().getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        try {
                            this.label = new Label((Composite)this.tip, 0);
                            this.label.setForeground(Display.getCurrent().getSystemColor(28));
                            this.label.setBackground(Display.getCurrent().getSystemColor(29));
                            this.label.setData("_TREEITEM", (Object)item);
                            Object data = item.getData();
                            if (data instanceof DecompositionItem) {
                                this.label.setText(((DecompositionItem)data).getStatusMessage());
                            } else {
                                this.label.setText(item.getText());
                            }
                            this.label.addListener(7, labelListener);
                            this.label.addListener(3, labelListener);
                            this.label.addListener(4, labelListener);
                            Point size = this.tip.computeSize(-1, -1);
                            Rectangle rect = item.getBounds(0);
                            Point pt = this.tree.toDisplay(rect.x, rect.y);
                            this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                            this.tip.setVisible(true);
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        return treeListener;
    }

    static void addListenerForSynthesisCheck(TreeViewer viewer) {
        final Tree tree = viewer.getTree();
        tree.addListener(13, new Listener(){
            Shell shell = null;
            Label label = null;

            public void handleEvent(Event arg0) {
                Event e = new Event();
                TreeItem item = null;
                if (currentShell != null) {
                    currentShell.dispose();
                    currentShell = null;
                }
                if (tree.getSelection().length > 0) {
                    item = tree.getSelection()[0];
                }
                if (item != null) {
                    e.item = item;
                    if (this.shell != null && !this.shell.isDisposed()) {
                        this.shell.dispose();
                    }
                    currentShell = this.shell = new Shell(tree.getShell(), 540676);
                    this.shell.setBackground(Display.getCurrent().getSystemColor(1));
                    FillLayout layout = new FillLayout();
                    layout.marginWidth = 0;
                    this.shell.setLayout((Layout)layout);
                    Object data = item.getData();
                    this.label = new Label((Composite)this.shell, 0x1000000);
                    this.label.setBackground(Display.getCurrent().getSystemColor(1));
                    this.label.setText(" ");
                    if (data instanceof DecompositionItem) {
                        DecompositionItem decompositionItem = (DecompositionItem)data;
                        switch (decompositionItem.getStatus()) {
                            case 1: {
                                this.label.setImage(_onceUsedImage);
                                this.label.setToolTipText(ONCE_USED);
                                break;
                            }
                            case 3: {
                                this.label.setImage(_multipleUsedImage);
                                this.label.setToolTipText(MULTIPLE_USED);
                                break;
                            }
                            case 2: {
                                this.label.setImage(_unUsedImage);
                                this.label.setToolTipText(UNUSED);
                                break;
                            }
                        }
                    } else {
                        this.shell.dispose();
                        this.shell = null;
                    }
                    if (this.shell != null && !this.shell.isDisposed()) {
                        Rectangle rect = item.getBounds(0);
                        Point pt = tree.toDisplay(rect.x, rect.y);
                        this.shell.setLocation(pt.x - 20, pt.y);
                        this.shell.pack();
                        this.shell.setVisible(true);
                    }
                }
            }
        });
    }

    void addContentProposal(List list, final Text text) {
        char[] autoActivationCharacters = new char[]{'#', '('};
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new DecompositionContentProposalProvider(list), keyStroke, autoActivationCharacters);
            adapter.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal proposal) {
                    DecompositionReuseContentProposal prop = (DecompositionReuseContentProposal)proposal;
                    DecompositionComponent comp = prop.getComponent();
                    text.setText(comp.getName());
                    text.setData((Object)comp);
                }
            });
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public static boolean isValidName(String name, Decomposition decomposition) {
        if (name == null || name.length() == 0) {
            return false;
        }
        for (DecompositionComponent comp : decomposition.getTargetComponents()) {
            if (!comp.getName().equals(name)) continue;
            return false;
        }
        return true;
    }
}

