/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.validation.design.consistency;

import com.google.common.base.Predicate;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.re.CompliancyDefinition;
import org.polarsys.capella.core.re.validation.design.consistency.AbstractComplianceConstraint;
import org.polarsys.capella.core.re.validation.design.consistency.ComplianceValidationContext;

public class BlackBoxComplianceWithExceptions
extends AbstractComplianceConstraint {
    private final Collection<EStructuralFeature> allowed;

    public BlackBoxComplianceWithExceptions(Predicate<CompliancyDefinition> compliancyDefinitionPredicate, Collection<EStructuralFeature> allowed) {
        super(compliancyDefinitionPredicate);
        this.allowed = allowed;
    }

    public BlackBoxComplianceWithExceptions(Collection<EStructuralFeature> allowed) {
        this(new Predicate<CompliancyDefinition>(){

            public boolean apply(CompliancyDefinition input) {
                return "BLACK_BOX".equals(input.getName());
            }
        }, allowed);
    }

    @Override
    protected IStatus validateAddReference(ComplianceValidationContext ctx, EReference ref, Object vRpl, Object expected) {
        if (this.allowed.contains(ref)) {
            return Status.OK_STATUS;
        }
        return ctx.createFailureStatus((EStructuralFeature)ref);
    }

    @Override
    protected IStatus validateRemoveReference(ComplianceValidationContext ctx, EReference ref, Object vRpl, Object vRec) {
        if (this.allowed.contains(ref)) {
            return Status.OK_STATUS;
        }
        return ctx.createFailureStatus((EStructuralFeature)ref);
    }

    @Override
    protected IStatus validateDifferentReference(ComplianceValidationContext ctx, EReference ref, Object vRpl, Object vRec) {
        if (this.allowed.contains(ref)) {
            return Status.OK_STATUS;
        }
        return ctx.createFailureStatus((EStructuralFeature)ref);
    }
}

