/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.validation.design.consistency;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.CompliancyDefinition;
import org.polarsys.capella.common.re.helpers.ReplicableElementExt;

public class ComplianceValidationContext {
    final CatalogElementLink rplLink;
    final IValidationContext ctx;

    static Collection<ComplianceValidationContext> create(IValidationContext ctx, Predicate<CompliancyDefinition> filter) {
        ArrayList<ComplianceValidationContext> result = new ArrayList<ComplianceValidationContext>();
        for (CatalogElementLink rplLink : ReplicableElementExt.getReferencingLinks((EObject)ctx.getTarget())) {
            EObject recElement;
            CatalogElementLink recLink;
            CatalogElement rpl = rplLink.getSource();
            if (rpl == null || rpl.getKind() != CatalogElementKind.RPL || rpl.getOrigin() == null || !rpl.isReadOnly() || !filter.apply((Object)rpl.getCurrentCompliancy()) || (recLink = rplLink.getOrigin()) == null || recLink.getSource() != rpl.getOrigin() || (recElement = recLink.getTarget()) == null || recElement.eClass() != ctx.getTarget().eClass()) continue;
            result.add(new ComplianceValidationContext(ctx, rplLink));
        }
        return result;
    }

    protected IStatus createFailureStatus() {
        return this.createFailureStatus(this.ctx.getFeature());
    }

    protected IStatus createFailureStatus(EStructuralFeature feature) {
        this.ctx.addResult(this.getRplElement());
        this.ctx.addResult((EObject)this.getRPL());
        return this.ctx.createFailureStatus(new Object[]{feature, this.getRplElement()});
    }

    ComplianceValidationContext(IValidationContext ctx, CatalogElementLink rplLink) {
        this.ctx = ctx;
        this.rplLink = rplLink;
    }

    public EObject getRplElement() {
        return this.rplLink.getTarget();
    }

    public EObject getRecElement() {
        return this.getRecLink().getTarget();
    }

    public CatalogElement getRPL() {
        return this.rplLink.getSource();
    }

    public CompliancyDefinition getCompliance() {
        return this.getRPL().getCurrentCompliancy();
    }

    public CatalogElementLink getRecLink() {
        return this.rplLink.getOrigin();
    }

    public CatalogElementLink getRplLink() {
        return this.rplLink;
    }

    public CatalogElement getREC() {
        return this.getRPL().getOrigin();
    }

    public IValidationContext getValidationContext() {
        return this.ctx;
    }
}

