/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.validation.abstractCapability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.validation.abstractCapability.Messages;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_Capability_Components_NotInvolved
extends AbstractValidationRule {
    private static final int ERROR_CODE = 1;

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        if (eType == EMFEventType.NULL && eObj instanceof AbstractCapability) {
            AbstractCapability capability = (AbstractCapability)eObj;
            List components = AbstractCapabilityExt.getInvolvedComponents((AbstractCapability)capability);
            List componentsInCapabilityScenarios = AbstractCapabilityExt.getComponentsFromAbstractCapabilityScenarios((AbstractCapability)capability);
            List componentsInCapabilityFunctionalChains = AbstractCapabilityExt.getComponentsFromAbstractCapabilityFunctionalChains((AbstractCapability)capability);
            HashSet allReferencedComponents = new HashSet();
            if (!componentsInCapabilityScenarios.isEmpty()) {
                allReferencedComponents.addAll(componentsInCapabilityScenarios);
            }
            if (!componentsInCapabilityFunctionalChains.isEmpty()) {
                allReferencedComponents.addAll(componentsInCapabilityFunctionalChains);
            }
            allReferencedComponents.removeAll(components);
            for (Component element : allReferencedComponents) {
                this.addCtxStatus(statuses, ctx, eObj, capability, element);
            }
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    private void addCtxStatus(Collection<IStatus> statuses, IValidationContext ctx, EObject eObj, AbstractCapability capability, Component element) {
        Object[] msgArguments = new Object[]{capability.getName(), EObjectLabelProviderHelper.getMetaclassLabel((EObject)capability, (boolean)false), CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)element), this.getFunctionalChainType(capability) + " or Scenarios"};
        ArrayList<Object> resultLocus = new ArrayList<Object>();
        resultLocus.add(capability);
        resultLocus.add(element);
        statuses.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)eObj, resultLocus, (int)2, (int)1, (String)Messages.DWF_CA_08_Validator_Message, (Object[])msgArguments));
    }

    private String getFunctionalChainType(AbstractCapability capability) {
        String type = "Functional Chains";
        if (capability instanceof OperationalCapability) {
            type = "Operational Processes";
        }
        return type;
    }
}

