/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.validation.scenario;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.validation.scenario.Messages;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_Scenario_InvolvementComponents_1
extends AbstractValidationRule {
    private static final int ERROR_CODE = 1;

    public IStatus validate(IValidationContext ctx_p) {
        Scenario scenario;
        AbstractCapability usecase;
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        if (eType == EMFEventType.NULL && eObj instanceof Scenario && !(eObj.eContainer() instanceof OperationalCapability) && !((Scenario)eObj).isMerged() && (usecase = ScenarioExt.getRelatedCapability((Scenario)(scenario = (Scenario)eObj))) != null) {
            List involvedElements = AbstractCapabilityExt.getInvolvedComponents((AbstractCapability)usecase);
            HashSet containedFunctions = new HashSet();
            for (Component comp : involvedElements) {
                containedFunctions.addAll(comp.getAllocatedFunctions());
            }
            containedFunctions.addAll(usecase.getInvolvedAbstractFunctions());
            for (InstanceRole instRole : scenario.getOwnedInstanceRoles()) {
                boolean isOk;
                AbstractInstance cpntInst = instRole.getRepresentedInstance();
                if (cpntInst == null) continue;
                Type cpnt = cpntInst.getType();
                if (cpnt != null) {
                    if (cpnt instanceof ExchangeItem) break;
                    if (involvedElements.contains(cpnt)) continue;
                    isOk = false;
                    if (cpnt instanceof GeneralizableElement) {
                        EList superElements = ((GeneralizableElement)cpnt).getSuper();
                        for (GeneralizableElement superElement : superElements) {
                            if (!involvedElements.contains(superElement)) continue;
                            isOk = true;
                            break;
                        }
                    }
                    if (isOk) continue;
                    this.addCtxStatus(statuses, ctx_p, eObj, usecase, (ModelElement)cpnt, cpnt.getName(), "Component");
                    continue;
                }
                if (containedFunctions.contains(cpntInst) || !(cpntInst instanceof AbstractFunction)) continue;
                isOk = false;
                AbstractFunction function = (AbstractFunction)cpntInst;
                List parentFunctions = FunctionExt.getParentFunctions((AbstractFunction)function);
                for (AbstractFunction parentFunction : parentFunctions) {
                    if (!containedFunctions.contains(parentFunction)) continue;
                    isOk = true;
                    break;
                }
                if (isOk) continue;
                this.addCtxStatus(statuses, ctx_p, eObj, usecase, (ModelElement)cpntInst, cpntInst.getName(), "Function");
            }
        }
        if (statuses.size() > 0) {
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx_p, statuses);
        }
        return ctx_p.createSuccessStatus();
    }

    private void addCtxStatus(Collection<IStatus> statuses, IValidationContext ctx_p, EObject eObj, AbstractCapability usecase, ModelElement element, String elementName, String contextName) {
        Object[] argMessage = new Object[]{elementName, contextName, usecase.getName(), EObjectLabelProviderHelper.getMetaclassLabel((EObject)usecase, (boolean)false)};
        ArrayList<Object> resultLocus = new ArrayList<Object>();
        resultLocus.add(eObj);
        resultLocus.add(usecase);
        resultLocus.add(element);
        statuses.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx_p, (EObject)eObj, resultLocus, (int)2, (int)1, (String)Messages.DCOM_05_Validator_Message, (Object[])argMessage));
    }
}

