/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.validation.scenario;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioRealization;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ScenarioRealizationCheck
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Scenario) {
            Scenario scenario = (Scenario)eObj;
            EList outgoingTraces = scenario.getIncomingTraces();
            if (!outgoingTraces.isEmpty()) {
                for (AbstractTrace abstractTrace : outgoingTraces) {
                    if (!(abstractTrace instanceof ScenarioRealization)) continue;
                    return ctx_p.createSuccessStatus();
                }
            }
            if (CapellaLayerCheckingExt.isAOrInEPBSLayer((CapellaElement)scenario)) {
                return ctx_p.createSuccessStatus();
            }
            return ctx_p.createFailureStatus(new Object[]{scenario.getName() + " (" + scenario.eClass().getName() + ") is not realized by any Scenario"});
        }
        return ctx_p.createSuccessStatus();
    }
}

