/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.richtext.clipboard;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.kitalpha.emde.model.Element;
import org.polarsys.kitalpha.richtext.widget.tools.manager.LinkManager;
import org.polarsys.kitalpha.richtext.widget.tools.manager.LinkManagerImpl;

public class RichTextLinksHelper {
    private static RichTextLinksHelper instance;
    private LinkManager linkManager = new LinkManagerImpl(null);

    private RichTextLinksHelper() {
    }

    public static RichTextLinksHelper getInstance() {
        if (instance == null) {
            instance = new RichTextLinksHelper();
        }
        return instance;
    }

    public String getElementsLinksHtml(Collection<EObject> elements) {
        return elements.stream().map(this::getElementLink).collect(Collectors.joining(" "));
    }

    private String getElementLink(EObject element) {
        Optional<Object> linkType = Optional.empty();
        if (element instanceof Element) {
            linkType = Optional.of("Model Element");
        } else if (element instanceof DRepresentationDescriptor) {
            linkType = Optional.of("Diagram Element");
        }
        if (linkType.isPresent()) {
            String type = (String)linkType.get();
            String id = IdManager.getInstance().getId(element);
            String label = EObjectLabelProviderHelper.getText((Object)element);
            return this.linkManager.encode(type, id, label);
        }
        return "";
    }
}

