/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.compare;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategorySet;
import org.eclipse.emf.diffmerge.ui.viewers.categories.DifferenceCategorySet;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.navigator.filters.CommonFilterDescriptor;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorFilterService;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;
import org.polarsys.capella.core.compare.Messages;
import org.polarsys.capella.core.compare.categories.EObjectCategoryFilter;
import org.polarsys.capella.core.platform.sirius.ui.navigator.filters.SemanticFiltersHelper;

public class CapellaDifferenceCategoryUtil {
    public static CapellaDifferenceCategoryUtil eINSTANCE = new CapellaDifferenceCategoryUtil();

    private CapellaDifferenceCategoryUtil() {
    }

    public void provideCapellaCategories(EMFDiffNode node_p) {
        DifferenceCategorySet diagramCategorySet = new DifferenceCategorySet(Messages.CapellaDifferenceCategoryProvider_CapellaSet_Text, Messages.CapellaDifferenceCategoryProvider_CapellaSet_Description);
        INavigatorFilterService filterService = NavigatorContentServiceFactory.INSTANCE.createContentService("capella.project.explorer").getFilterService();
        Comparator<ICommonFilterDescriptor> sortByName = new Comparator<ICommonFilterDescriptor>(){

            @Override
            public int compare(ICommonFilterDescriptor o1_p, ICommonFilterDescriptor o2_p) {
                return o1_p.getName().compareTo(o2_p.getName());
            }
        };
        List itemList = Arrays.asList(filterService.getVisibleFilterDescriptors()).stream().filter(d -> d instanceof CommonFilterDescriptor).map(CommonFilterDescriptor.class::cast).filter(d -> d.isVisibleInUi() && SemanticFiltersHelper.isSemanticFilter((ICommonFilterDescriptor)d)).collect(Collectors.toList());
        Collections.sort(itemList, sortByName);
        for (CommonFilterDescriptor descriptor : itemList) {
            final ViewerFilter f = descriptor.createFilter();
            diagramCategorySet.getChildren().add((Object)new EObjectCategoryFilter(descriptor.getId(), descriptor.getName(), false){

                @Override
                public boolean keepElement(Object element) {
                    return !f.select(null, null, element);
                }
            });
        }
        node_p.getCategoryManager().addCategories((IDifferenceCategorySet)diagramCategorySet);
    }
}

