/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.pa.validation.physicalComponent;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class DeploymentChildPCChecks
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof PhysicalComponent) {
            PhysicalComponent nodePC;
            PhysicalComponent currentElement = (PhysicalComponent)eObj;
            if (PhysicalComponentExt.isNode((PhysicalComponent)currentElement)) {
                PhysicalComponent deployingBehaviorPC = this.getDeployingComponent(currentElement, PhysicalComponentNature.BEHAVIOR);
                if (deployingBehaviorPC != null) {
                    return ctx.createFailureStatus(new Object[]{CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)currentElement) + "can't be deployed on " + CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)deployingBehaviorPC)});
                }
                PhysicalComponent behaviorPC = this.getContainingComponent(currentElement, PhysicalComponentNature.BEHAVIOR);
                if (behaviorPC != null) {
                    return ctx.createFailureStatus(new Object[]{CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)currentElement) + "can't be contained in " + CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)behaviorPC)});
                }
            } else if (PhysicalComponentExt.isBehaviour((PhysicalComponent)currentElement) && (nodePC = this.getContainingComponent(currentElement, PhysicalComponentNature.NODE)) != null) {
                return ctx.createFailureStatus(new Object[]{CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)currentElement) + "can't be contained in " + CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)nodePC)});
            }
        }
        return ctx.createSuccessStatus();
    }

    protected PhysicalComponent getDeployingComponent(PhysicalComponent physicalComponent, PhysicalComponentNature nature) {
        EList deployingPhysicalComponents = physicalComponent.getDeployingPhysicalComponents();
        for (PhysicalComponent capellaElement : deployingPhysicalComponents) {
            if (capellaElement.getNature() != nature) continue;
            return capellaElement;
        }
        return null;
    }

    protected PhysicalComponent getContainingComponent(PhysicalComponent physicalComponent, PhysicalComponentNature nature) {
        List allAncestors = ComponentExt.getAllPartitionableElementAncestors((Component)physicalComponent);
        for (Component component : allAncestors) {
            PhysicalComponent comp;
            if (!(component instanceof PhysicalComponent) || (comp = (PhysicalComponent)component).getNature() != nature || PhysicalComponentExt.isPhysicalComponentRoot((EObject)comp)) continue;
            return comp;
        }
        return null;
    }
}

