/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.pa.validation.physicalComponent;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class DeploymentParentPCChecks
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        if (eType == EMFEventType.NULL && eObj instanceof PhysicalComponent) {
            PhysicalComponent currentElement = (PhysicalComponent)eObj;
            if (PhysicalComponentExt.isNode((PhysicalComponent)currentElement)) {
                List<PhysicalComponent> containedComponents = this.getContainedComponents(currentElement, PhysicalComponentNature.BEHAVIOR);
                if (!containedComponents.isEmpty()) {
                    IStatus createFailureStatus = ctx.createFailureStatus(new Object[]{CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)currentElement) + "can't contain BEHAVIOR components."});
                    statuses.add(createFailureStatus);
                }
            } else if (PhysicalComponentExt.isBehaviour((PhysicalComponent)currentElement)) {
                List<PhysicalComponent> deployedComponents;
                List<PhysicalComponent> containedComponents = this.getContainedComponents(currentElement, PhysicalComponentNature.NODE);
                if (!containedComponents.isEmpty()) {
                    IStatus createFailureStatus = ctx.createFailureStatus(new Object[]{CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)currentElement) + "can't contain NODE components."});
                    statuses.add(createFailureStatus);
                }
                if (!(deployedComponents = this.getDeployedComponents(currentElement, PhysicalComponentNature.NODE)).isEmpty()) {
                    IStatus createFailureStatus = ctx.createFailureStatus(new Object[]{CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)currentElement) + "can't deploy NODE components."});
                    statuses.add(createFailureStatus);
                }
            }
        }
        if (!statuses.isEmpty()) {
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
        }
        return ctx.createSuccessStatus();
    }

    private List<PhysicalComponent> getContainedComponents(PhysicalComponent physicalComponent, PhysicalComponentNature nature) {
        ArrayList<PhysicalComponent> result = new ArrayList<PhysicalComponent>();
        EList subComponents = physicalComponent.getSubPhysicalComponents();
        EList deployedcomponents = physicalComponent.getDeployedPhysicalComponents();
        for (PhysicalComponent component : subComponents) {
            if (component.getNature() != nature || deployedcomponents.contains((Object)component)) continue;
            result.add(component);
        }
        return result;
    }

    private List<PhysicalComponent> getDeployedComponents(PhysicalComponent physicalComponent, PhysicalComponentNature nature) {
        ArrayList<PhysicalComponent> result = new ArrayList<PhysicalComponent>();
        EList deployedcomponents = physicalComponent.getDeployedPhysicalComponents();
        for (PhysicalComponent component : deployedcomponents) {
            if (component.getNature() != nature) continue;
            result.add(component);
        }
        return result;
    }
}

