/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.rules.cs;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.rules.AbstractCapellaElementRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class InterfacePkgRule
extends AbstractCapellaElementRule {
    @Override
    protected EClass getSourceType() {
        return CsPackage.Literals.INTERFACE_PKG;
    }

    protected EObject getDefaultContainer(EObject element, EObject result, IContext context) {
        EObject root = TransformationHandlerHelper.getInstance((IContext)context).getLevelElement(element, context);
        BlockArchitecture target = (BlockArchitecture)TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement(root, context, CsPackage.Literals.BLOCK_ARCHITECTURE, element, result);
        return BlockArchitectureExt.getInterfacePkg((BlockArchitecture)target);
    }

    @Override
    protected void retrieveGoDeep(EObject source, List<EObject> result, IContext context) {
        super.retrieveGoDeep(source, result, context);
        if (ContextScopeHandlerHelper.getInstance((IContext)context).contains("SOURCE_SCOPE", source, context)) {
            InterfacePkg pkg = (InterfacePkg)source;
            result.addAll((Collection<EObject>)pkg.getOwnedInterfacePkgs());
            result.addAll((Collection<EObject>)pkg.getOwnedInterfaces());
            result.addAll((Collection<EObject>)pkg.getOwnedExchangeItems());
        }
    }

    protected void retrieveContainer(EObject element, List<EObject> result, IContext context) {
        if (!(element.eContainer() instanceof Component) && !(element.eContainer() instanceof BlockArchitecture)) {
            super.retrieveContainer(element, result, context);
        }
    }

    protected EStructuralFeature getTargetContainementFeature(EObject element, EObject result, EObject container, IContext context) {
        if (container instanceof Block) {
            return CsPackage.Literals.BLOCK__OWNED_INTERFACE_PKG;
        }
        if (container instanceof InterfacePkg) {
            return CsPackage.Literals.INTERFACE_PKG__OWNED_INTERFACE_PKGS;
        }
        if (container instanceof BlockArchitecture) {
            return CsPackage.Literals.BLOCK_ARCHITECTURE__OWNED_INTERFACE_PKG;
        }
        return super.getTargetContainementFeature(element, result, container, context);
    }
}

