/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.handlers.traceability;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.capella.common.re.handlers.traceability.LocationTraceabilityConfiguration;
import org.polarsys.capella.common.re.handlers.traceability.LocationTraceabilityHandler;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ProjectExt;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.LevelBasedTraceabilityHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class CapellaLocationTraceabilityConfiguration
extends LocationTraceabilityConfiguration {
    protected void initHandlers(final IContext context) {
        super.initHandlers(context);
        this.addHandler(context, (ITraceabilityHandler)new LevelBasedTraceabilityHandler(this.getIdentifier(context)){

            public Collection<EObject> retrieveTracedElements(EObject source, IContext iContext) {
                if (source instanceof BlockArchitecture) {
                    if (CapellaLocationTraceabilityConfiguration.this.isSourceKind()) {
                        CatalogElement sourceElement = ReplicableElementHandlerHelper.getInstance((IContext)context).getInitialSource(context);
                        Resource resource = EcoreUtil.getRootContainer((EObject)sourceElement).eResource();
                        Project project = ProjectExt.getProject((Resource)resource);
                        BlockArchitecture targetArchitecture = BlockArchitectureExt.getBlockArchitecture((EClass)source.eClass(), (Project)project);
                        if (targetArchitecture != null) {
                            return Collections.singletonList(targetArchitecture);
                        }
                    } else {
                        CatalogElement targetElement = ReplicableElementHandlerHelper.getInstance((IContext)context).getInitialTarget(context);
                        Resource resource = EcoreUtil.getRootContainer((EObject)targetElement).eResource();
                        Project project = ProjectExt.getProject((Resource)resource);
                        BlockArchitecture targetArchitecture = BlockArchitectureExt.getBlockArchitecture((EClass)source.eClass(), (Project)project);
                        if (targetArchitecture != null) {
                            return Collections.singletonList(targetArchitecture);
                        }
                    }
                }
                return Collections.emptyList();
            }

            public Collection<EObject> retrieveSourceElements(EObject source, IContext context_p) {
                if (source instanceof BlockArchitecture) {
                    if (CapellaLocationTraceabilityConfiguration.this.isSourceKind()) {
                        CatalogElement sourceElement = ReplicableElementHandlerHelper.getInstance((IContext)context).getInitialSource(context);
                        Resource resource = EcoreUtil.getRootContainer((EObject)sourceElement).eResource();
                        Project project = ProjectExt.getProject((Resource)resource);
                        BlockArchitecture targetArchitecture = BlockArchitectureExt.getBlockArchitecture((EClass)source.eClass(), (Project)project);
                        if (targetArchitecture != null) {
                            return Collections.singletonList(targetArchitecture);
                        }
                    } else {
                        CatalogElement targetElement = ReplicableElementHandlerHelper.getInstance((IContext)context).getInitialTarget(context);
                        Resource resource = EcoreUtil.getRootContainer((EObject)targetElement).eResource();
                        Project project = ProjectExt.getProject((Resource)resource);
                        BlockArchitecture targetArchitecture = BlockArchitectureExt.getBlockArchitecture((EClass)source.eClass(), (Project)project);
                        if (targetArchitecture != null) {
                            return Collections.singletonList(targetArchitecture);
                        }
                    }
                }
                return Collections.emptyList();
            }
        });
    }

    public boolean useHandlerForSourceElements(EObject source, ITraceabilityHandler handler, IContext context) {
        if (source instanceof BlockArchitecture && handler instanceof LocationTraceabilityHandler) {
            return false;
        }
        return super.useHandlerForSourceElements(source, handler, context);
    }

    public boolean useHandlerForTracedElements(EObject source, ITraceabilityHandler handler, IContext context) {
        if (source instanceof BlockArchitecture && handler instanceof LocationTraceabilityHandler) {
            return false;
        }
        return super.useHandlerForTracedElements(source, handler, context);
    }

    protected String getExtensionIdentifier(IContext context_p) {
        return "MATCH";
    }
}

