/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.preferences.configuration.project.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.preferences.configuration.project.ConfigurationProject;
import org.polarsys.capella.core.preferences.configuration.project.nature.ConfigurationProjectNature;
import org.polarsys.capella.core.preferences.project.configuration.project.ConfigurationPlugin;

public final class ReferecedConfigurationProjectSelectionPage
extends WizardPage {
    private static final String[] COLUMNS = new String[]{" ", "icon", "project name"};
    final TableViewerAwareCellModifier cellModifier;
    final IBaseLabelProvider labelProvider;
    private Set<ConfigurationProject> configurationProjects;

    public ReferecedConfigurationProjectSelectionPage(String pageName_p, String[] projectsNaturesIds) {
        this(pageName_p, "Referenced Capella Configuration Project", ConfigurationPlugin.getImageDescriptor("config_project_wizard.gif"), projectsNaturesIds);
        this.initilizeSelectedProject(projectsNaturesIds);
    }

    public ReferecedConfigurationProjectSelectionPage(String pageName_p, String title, ImageDescriptor imageDescriptor_p, String[] all) {
        super(pageName_p, title, imageDescriptor_p);
        this.initilizeSelectedProject(all);
        this.labelProvider = new WizardTableLabelProvider();
        this.cellModifier = new WizardPageTableCellModifier(this.configurationProjects, this.getContainer());
    }

    private void initilizeSelectedProject(String[] projectsNaturesIds_p) {
        IProject[] projects;
        this.configurationProjects = new HashSet<ConfigurationProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.isProjectAutorized(project, projectsNaturesIds_p)) {
                this.configurationProjects.add(new ConfigurationProject(project, Boolean.FALSE));
            }
            ++n2;
        }
    }

    public List<IProject> getSelectedConfigurationsProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        if (this.configurationProjects != null && !this.configurationProjects.isEmpty()) {
            for (ConfigurationProject configurationProject : this.configurationProjects) {
                if (!configurationProject.getIsSelected().booleanValue() || projects.contains(configurationProject.getProject())) continue;
                projects.add(configurationProject.getProject());
            }
        }
        return projects;
    }

    private boolean isProjectAutorized(IProject iProject_p, String[] projectsNaturesIds_p) {
        IProjectNature nature = null;
        String[] stringArray = projectsNaturesIds_p;
        int n = projectsNaturesIds_p.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            try {
                nature = iProject_p.getNature(element);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (nature != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void createControl(Composite composite) {
        Composite control = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        control.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        control.setLayout((Layout)gridLayout);
        TableViewer tableViewer = new TableViewer(control, 67584);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        Table table = tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn tc0 = new TableColumn(table, 0x1000000, 0);
        tc0.setWidth(30);
        TableColumn tc1 = new TableColumn(table, 0x1000000, 1);
        tc1.setWidth(30);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 16384, 2);
        column.getColumn().setWidth(450);
        table.setSize(new Point(table.getSize().x, 510));
        CellEditor[] editors = new CellEditor[3];
        editors[0] = new CheckboxCellEditor((Composite)table);
        int i = 1;
        while (i < 3) {
            editors[i] = null;
            ++i;
        }
        tableViewer.setColumnProperties(COLUMNS);
        tableViewer.setCellEditors(editors);
        this.cellModifier.setViewer(tableViewer);
        tableViewer.setCellModifier((ICellModifier)this.cellModifier);
        tableViewer.setContentProvider((IContentProvider)new WizardTableContentProvider());
        tableViewer.setLabelProvider(this.labelProvider);
        tableViewer.setComparator(new ViewerComparator());
        tableViewer.setInput(this.configurationProjects);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        this.setControl((Control)control);
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    private static abstract class AbstractWizardTableCellModifier
    implements TableViewerAwareCellModifier {
        protected TableViewer tableViewer;
        protected final Set<ConfigurationProject> configurationProjects;

        public AbstractWizardTableCellModifier(Set<ConfigurationProject> configurationProjects) {
            this.configurationProjects = configurationProjects;
        }

        @Override
        public void setViewer(TableViewer viewer) {
            this.tableViewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return property.equals(COLUMNS[0]);
        }
    }

    private static class ConfigurationProjectTableLazyCellModifier
    extends AbstractWizardTableCellModifier {
        public ConfigurationProjectTableLazyCellModifier(Set<ConfigurationProject> configurationProjects) {
            super(configurationProjects);
        }

        public Object getValue(Object element, String property) {
            ConfigurationProject tableProjectConfiguration = (ConfigurationProject)element;
            Object result = Boolean.FALSE;
            if (property.equals(COLUMNS[0])) {
                if (!tableProjectConfiguration.getProject().isOpen() || !tableProjectConfiguration.getProject().isAccessible()) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Closed Configuration Project", (String)"The selected Project must be opened and accessible");
                } else {
                    Iterator iterator = this.configurationProjects.iterator();
                    while (iterator.hasNext()) {
                        ConfigurationProject configurationProject;
                        ConfigurationProject currentProject = configurationProject = (ConfigurationProject)iterator.next();
                        if (!tableProjectConfiguration.getProject().getName().equals(currentProject.getProject().getName()) || !currentProject.getProject().isOpen() || !currentProject.getProject().isAccessible() || !tableProjectConfiguration.getIsSelected().booleanValue()) continue;
                        result = Boolean.TRUE;
                        break;
                    }
                }
            } else if (!property.equals(COLUMNS[1])) {
                result = tableProjectConfiguration.getProject().getName();
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            Object objElement = element instanceof Item ? ((Item)element).getData() : element;
            if (property.equals(COLUMNS[0])) {
                ConfigurationProject vp = (ConfigurationProject)objElement;
                Boolean result = Boolean.TRUE.equals(value);
                vp.setIsSelected(result);
                this.tableViewer.update((Object)vp, null);
            }
        }
    }

    private static interface TableViewerAwareCellModifier
    extends ICellModifier {
        public void setViewer(TableViewer var1);
    }

    private static class WizardPageTableCellModifier
    extends ConfigurationProjectTableLazyCellModifier {
        private final IWizardContainer wizardContainer;

        public WizardPageTableCellModifier(Set<ConfigurationProject> configurationProjects, IWizardContainer wizardContainer) {
            super(configurationProjects);
            this.wizardContainer = wizardContainer;
        }

        @Override
        public void modify(Object element, String property, Object value) {
            super.modify(element, property, value);
            if (property.equals(COLUMNS[0]) && this.wizardContainer != null) {
                this.wizardContainer.updateButtons();
            }
        }
    }

    private static final class WizardTableContentProvider
    implements IStructuredContentProvider {
        private WizardTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Set) {
                return ((Set)inputElement).toArray();
            }
            return Collections.EMPTY_LIST.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static final class WizardTableLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        private Image getOtherProjectIcon() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            ISharedImages sharedImages = workbench.getSharedImages();
            Image image = sharedImages.getImage("IMG_OBJ_PROJECT");
            image = ConfigurationPlugin.getOverlayedDescriptor(image, "capella_8x8.png").createImage();
            return image;
        }

        private Image getConfigurationProjectIcon() {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            Image image = sharedImages.getImage("IMG_OBJ_PROJECT");
            image = ConfigurationPlugin.getOverlayedDescriptor(image, "config_8x8.gif").createImage();
            return image;
        }

        public Image getImage(Object element) {
            Image image = null;
            switch (this.columnIndex) {
                case 0: {
                    if (!(element instanceof ConfigurationProject)) break;
                    ConfigurationProject vp = (ConfigurationProject)element;
                    image = ConfigurationPlugin.getImageDescriptor("disabled_checkbox.gif").createImage();
                    if (!vp.getIsSelected().booleanValue()) break;
                    image = ConfigurationPlugin.getImageDescriptor("enabled_checkbox.gif").createImage();
                    break;
                }
                case 1: {
                    if (!(element instanceof ConfigurationProject)) break;
                    ConfigurationProject vp = (ConfigurationProject)element;
                    image = this.getProjectIcon(vp.getProject());
                    break;
                }
                case 2: {
                    break;
                }
            }
            return image;
        }

        private Image getProjectIcon(IProject project_p) {
            IProjectNature nature = ConfigurationProjectNature.hasConfigurationProject(project_p);
            if (nature != null) {
                return this.getConfigurationProjectIcon();
            }
            return this.getOtherProjectIcon();
        }

        public String getText(Object element) {
            switch (this.columnIndex) {
                case 2: {
                    if (!(element instanceof ConfigurationProject)) break;
                    return ((ConfigurationProject)element).getProject().getName();
                }
            }
            return null;
        }

        public String getToolTipText(Object element) {
            Object toolTip = "";
            if (this.columnIndex == 2 && element instanceof ConfigurationProject) {
                ConfigurationProject viewpoint = (ConfigurationProject)element;
                try {
                    toolTip = (String)toolTip + viewpoint.getProject().getDescription().getName();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return toolTip;
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 200;
        }

        public void update(ViewerCell cell) {
            this.columnIndex = cell.getColumnIndex();
            super.update(cell);
        }

        public int getToolTipStyle(Object object) {
            return 8;
        }
    }
}

