/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectNewRepresentationDialog;
import org.polarsys.capella.core.sirius.analysis.commands.NewRepresentationCommand;
import org.polarsys.capella.core.sirius.ui.actions.AbstractNewRepresentationAction;
import org.polarsys.capella.core.sirius.ui.actions.Messages;

public class SelectNewRepresentationAction
extends AbstractNewRepresentationAction {
    protected Set<RepresentationDescription> descriptions;

    public SelectNewRepresentationAction(Collection<RepresentationDescription> descriptions, EObject selectedEObject, Session session, String message) {
        this(descriptions, selectedEObject, session, true);
        this.message = message + "\n" + this.message;
    }

    public SelectNewRepresentationAction(Collection<RepresentationDescription> descriptions, EObject selectedEObject, Session session) {
        this(descriptions, selectedEObject, session, true);
    }

    public SelectNewRepresentationAction(Collection<RepresentationDescription> descriptions, EObject selectedEObject, Session session, boolean openRepresentation) {
        super(Messages.SelectNewRepresentation);
        this.message = Messages.SelectNewRepresentation;
        this.selectedEObject = selectedEObject;
        this.descriptions = new HashSet<RepresentationDescription>(descriptions);
        this.session = session;
        this.openRepresentation = openRepresentation;
        RepresentationDescription firstDescription = descriptions.iterator().next();
        ImageDescriptor imageDescriptor = this.getDescriptionImageDescriptor(firstDescription);
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        Shell activeShell = Display.getDefault().getActiveShell();
        SelectNewRepresentationDialog dialog = new SelectNewRepresentationDialog(activeShell, this.message, this.selectedEObject, this.descriptions);
        boolean bl = this.isCanceled = 1 == dialog.open();
        if (this.isCanceled) {
            return;
        }
        String name = dialog.getName();
        RepresentationDescription selectedDescription = dialog.getSelectedRepresentationDescription();
        NewRepresentationCommand command = new NewRepresentationCommand(name, this.selectedEObject, selectedDescription, this.session);
        TransactionHelper.getExecutionManager((Session)this.session).execute((ICommand)command);
        if (command.getRepresentation() != null) {
            SessionManager.INSTANCE.notifyRepresentationCreated(this.session);
            if (this.openRepresentation) {
                DialectUIManager.INSTANCE.openEditor(this.session, command.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

