/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.copyformat;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeRealization;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchangeRealization;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortRealization;
import org.polarsys.capella.core.sirius.ui.copyformat.AbstractCapellaFormatDataKey;
import org.polarsys.capella.core.sirius.ui.copyformat.CapellaDecoratorFormatDataKey;

public class CapellaTraceabilityFormatDataKey
extends CapellaDecoratorFormatDataKey {
    public CapellaTraceabilityFormatDataKey(AbstractCapellaFormatDataKey key, EObject semantic) {
        super(key);
        this._semantic = semantic;
        if (this.parent instanceof CapellaDecoratorFormatDataKey) {
            for (EObject decoration : ((CapellaDecoratorFormatDataKey)this.parent).getDecorations()) {
                EObject traced;
                if (!(decoration instanceof EObject) || (traced = this.retrieveLinkedEObject(decoration)) == null) continue;
                this.addDecoration(traced);
            }
        }
    }

    @Override
    public EObject getSemantic() {
        return this._semantic;
    }

    protected EObject retrieveLinkedEObject(EObject semantic) {
        Part part;
        EObject obj;
        TraceableElement source = null;
        if (semantic instanceof EClass || semantic instanceof ColorDescription) {
            return semantic;
        }
        if (semantic instanceof TraceableElement) {
            TraceableElement sourceOfTrace = (TraceableElement)semantic;
            for (AbstractTrace trace : sourceOfTrace.getOutgoingTraces()) {
                if (!this.isValidTrace(trace)) continue;
                source = trace.getTargetElement();
            }
        }
        if (source == null && semantic instanceof Part && (obj = this.retrieveLinkedEObject((EObject)(part = (Part)semantic).getAbstractType())) instanceof Component) {
            Component linkedComponent = (Component)obj;
            for (Object ate : linkedComponent.getAbstractTypedElements()) {
                if (!(ate instanceof Part)) continue;
                return (Part)ate;
            }
        }
        return source;
    }

    private boolean isValidTrace(AbstractTrace trace) {
        if (trace.getSourceElement() == null || trace.getTargetElement() == null) {
            return false;
        }
        if (trace.getSourceElement() instanceof Port) {
            return trace instanceof PortRealization;
        }
        if (trace.getSourceElement() instanceof ComponentExchange) {
            return trace instanceof ComponentExchangeRealization;
        }
        if (trace.getSourceElement() instanceof FunctionalExchange) {
            return trace instanceof FunctionalExchangeRealization;
        }
        return true;
    }
}

