/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.handlers;

import java.util.Collection;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.util.IJobConstants;
import org.polarsys.capella.core.sirius.ui.handlers.Messages;
import org.polarsys.capella.core.sirius.ui.handlers.RemoveHiddenElementsCommand;

public class DeleteHiddenElementsJob
extends WorkspaceJob {
    private Session _session;
    private Collection<DRepresentationDescriptor> _representationsToRefresh;
    private boolean _unsynchDiags;

    public DeleteHiddenElementsJob(Collection<DRepresentationDescriptor> representationsToRefresh_p, Session session_p, boolean unsyncDiags_p) {
        super(Messages.RemoveHiddenElementsHandler_JobName);
        this.setProperty(IJobConstants.ALWAYS_LOG_STATUS, true);
        this._session = session_p;
        this._representationsToRefresh = representationsToRefresh_p;
        this._unsynchDiags = unsyncDiags_p;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor_p) throws CoreException {
        RemoveHiddenElementsCommand deleteHiddenEltCmd = new RemoveHiddenElementsCommand(this._representationsToRefresh, TransactionHelper.getExecutionManager((Session)this._session), this._unsynchDiags);
        TransactionHelper.getExecutionManager((Session)this._session).execute((ICommand)deleteHiddenEltCmd);
        return deleteHiddenEltCmd.getStatus();
    }
}

