/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.handlers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.ui.SiriusUIPlugin;

public class RemoveHiddenElementsCommand
extends AbstractReadWriteCommand
implements ICommand,
RunnableWithResult<IStatus> {
    private Collection<DRepresentationDescriptor> representationsToClean;
    private boolean _doUnsynchronizeDiagrams;
    private IStatus result = Status.OK_STATUS;

    public RemoveHiddenElementsCommand(Collection<DRepresentationDescriptor> representationsToRefresh_p, ExecutionManager executionManager, boolean doUnsynchronizeDiagrams_p) {
        this.representationsToClean = representationsToRefresh_p;
        this._doUnsynchronizeDiagrams = doUnsynchronizeDiagrams_p;
    }

    public String getName() {
        return "Remove hidden elements";
    }

    public void run() {
        this.setStatus(this.deleteHidden(this.representationsToClean));
    }

    public IStatus getResult() {
        return this.result;
    }

    public void setStatus(IStatus status) {
        this.result = status;
    }

    public IStatus getStatus() {
        return this.result;
    }

    private IStatus deleteHidden(Collection<DRepresentationDescriptor> selection_p) {
        ArrayList<Status> childs = new ArrayList<Status>();
        for (DRepresentationDescriptor descriptor : selection_p) {
            DRepresentation representation;
            RepresentationDescription description = descriptor.getDescription();
            if (!(description instanceof DiagramDescription) || !((representation = descriptor.getRepresentation()) instanceof DDiagram)) continue;
            DDiagram diagram = (DDiagram)representation;
            int count = 0;
            ArrayList<DDiagramElement> elements = new ArrayList<DDiagramElement>();
            Iterable diagramElements = DiagramServices.getDiagramServices().getDiagramElements((EObject)diagram);
            for (DDiagramElement element : diagramElements) {
                if (element.isVisible()) continue;
                elements.add(element);
            }
            if (this._doUnsynchronizeDiagrams) {
                diagram.setSynchronized(false);
            }
            for (DDiagramElement element : elements) {
                RepresentationElementMapping mapping = element.getMapping();
                if (!(mapping instanceof DiagramElementMapping)) continue;
                if (this._doUnsynchronizeDiagrams) {
                    this.removeDiagramElt(element);
                    ++count;
                    continue;
                }
                boolean toRemove = RemoveHiddenElementsCommand.isNotSynchronizedMapping((DiagramElementMapping)mapping);
                if (!toRemove) continue;
                this.removeDiagramElt(element);
                ++count;
            }
            if (count <= 0) continue;
            childs.add(new Status(0, SiriusUIPlugin.getDefault().getPluginId(), NLS.bind((String)"Removing {0} element(s) from diagram: {2}", (Object[])new String[]{Integer.toString(count), descriptor.getName()})));
        }
        if (childs.isEmpty()) {
            return new Status(1, SiriusUIPlugin.getDefault().getPluginId(), NLS.bind((String)"{0}: Nothing to do", (Object)this.getName()));
        }
        MultiStatus status = new MultiStatus(SiriusUIPlugin.getDefault().getPluginId(), 0, NLS.bind((String)"{0}: {1} diagram(s) updated", (Object)this.getName(), (Object)childs.size()), null);
        return status;
    }

    public static boolean isNotSynchronizedMapping(DiagramElementMapping mapping_p) {
        boolean synchronizationLock = mapping_p.isSynchronizationLock();
        boolean createElts = mapping_p.isCreateElements();
        return !synchronizationLock && !createElts;
    }

    private void removeDiagramElt(DDiagramElement element) {
        DEdge edge;
        if (element instanceof DDiagram || element instanceof DDiagramElementContainer) {
            DiagramServices.getDiagramServices().removeContainerView((EObject)element);
        } else if (element instanceof DNode) {
            DiagramServices.getDiagramServices().removeNodeView((DNode)element);
        } else if (element instanceof DEdge && (edge = (DEdge)element).getSourceNode() != null && edge.getTargetNode() != null) {
            DiagramServices.getDiagramServices().removeEdgeView(edge);
        }
    }
}

