/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;

public class SelectionHelper {
    public static SelectionHelper eINSTANCE = new SelectionHelper();

    private SelectionHelper() {
    }

    public boolean hasElementsOfSameType(IStructuredSelection selection) {
        return !this.getElementsOfSameType(selection).isEmpty();
    }

    public Collection<DDiagramElement> getElementsOfSameType(IStructuredSelection selection) {
        List<DSemanticDecorator> semanticDecorators = this.getDSemanticDecoratorsFromSelection(selection);
        if (semanticDecorators.isEmpty() || semanticDecorators.size() != selection.size()) {
            return new ArrayList<DDiagramElement>();
        }
        DSemanticDiagram diagram = (DSemanticDiagram)DiagramHelper.getService().getDiagramContainer((EObject)semanticDecorators.get(0));
        return DiagramServices.getDiagramServices().getViewsRepresentingSameEType(diagram, semanticDecorators);
    }

    public Collection<DDiagramElement> getRelatedFunctionalChainElements(IStructuredSelection selection) {
        List<DSemanticDecorator> semanticDecorators = this.getDSemanticDecoratorsFromSelection(selection);
        if (semanticDecorators.isEmpty() || semanticDecorators.size() != selection.size()) {
            return new ArrayList<DDiagramElement>();
        }
        DSemanticDiagram diagram = (DSemanticDiagram)DiagramHelper.getService().getDiagramContainer((EObject)semanticDecorators.get(0));
        return DiagramServices.getDiagramServices().getRelatedFunctionalChainElements(diagram, semanticDecorators);
    }

    public Collection<DDiagramElement> getRelatedPhysicalPathElements(IStructuredSelection selection) {
        List<DSemanticDecorator> semanticDecorators = this.getDSemanticDecoratorsFromSelection(selection);
        if (semanticDecorators.isEmpty() || semanticDecorators.size() != selection.size()) {
            return new ArrayList<DDiagramElement>();
        }
        DSemanticDiagram diagram = (DSemanticDiagram)DiagramHelper.getService().getDiagramContainer((EObject)semanticDecorators.get(0));
        return DiagramServices.getDiagramServices().getRelatedPhysicalPathElements(diagram, semanticDecorators);
    }

    public boolean hasResemblingElements(IStructuredSelection selection) {
        return !this.getResemblingElements(selection).isEmpty();
    }

    public Collection<DDiagramElement> getResemblingElements(IStructuredSelection selection) {
        List<DSemanticDecorator> semanticDecorators = this.getDSemanticDecoratorsFromSelection(selection);
        if (semanticDecorators.isEmpty() || semanticDecorators.size() != selection.size()) {
            return new ArrayList<DDiagramElement>();
        }
        DSemanticDiagram diagram = (DSemanticDiagram)DiagramHelper.getService().getDiagramContainer((EObject)semanticDecorators.get(0));
        return DiagramServices.getDiagramServices().getViewsWithSameMapping(diagram, semanticDecorators);
    }

    protected List<GraphicalEditPart> getGraphicalEditPartsFromSelection(IStructuredSelection selection) {
        ArrayList<GraphicalEditPart> editParts = new ArrayList<GraphicalEditPart>();
        for (Object selectedElement : selection.toList()) {
            if (!(selectedElement instanceof GraphicalEditPart)) continue;
            editParts.add((GraphicalEditPart)selectedElement);
        }
        return editParts;
    }

    protected List<DSemanticDecorator> getDSemanticDecoratorsFromSelection(IStructuredSelection selection) {
        List<GraphicalEditPart> editParts = this.getGraphicalEditPartsFromSelection(selection);
        List<DSemanticDecorator> semanticDecorators = editParts.stream().filter(selectedElement -> selectedElement instanceof GraphicalEditPart).map(editPart -> editPart.getModel()).filter(model -> model instanceof View).map(model -> ((View)model).getElement()).filter(element -> element instanceof DSemanticDecorator).map(DSemanticDecorator.class::cast).collect(Collectors.toList());
        return semanticDecorators;
    }

    public boolean hasOwnedPorts(IStructuredSelection selection) {
        return !this.getOwnedPorts(selection).isEmpty();
    }

    public Collection<DNode> getOwnedPorts(IStructuredSelection selection) {
        List<DSemanticDecorator> semanticDecorators = this.getDSemanticDecoratorsFromSelection(selection);
        DSemanticDiagram diagram = (DSemanticDiagram)DiagramHelper.getService().getDiagramContainer((EObject)semanticDecorators.get(0));
        return DiagramServices.getDiagramServices().getAllOwnedPorts(diagram, semanticDecorators);
    }

    public boolean hasOwnedElements(IStructuredSelection selection) {
        return !this.getOwnedElements(selection).isEmpty();
    }

    public Collection<DDiagramElement> getOwnedElements(IStructuredSelection selection) {
        List<DSemanticDecorator> semanticDecorators = this.getDSemanticDecoratorsFromSelection(selection);
        if (semanticDecorators.stream().filter(aDecorator -> aDecorator instanceof DNodeContainer).count() == 0L) {
            return Collections.emptyList();
        }
        DSemanticDiagram diagram = (DSemanticDiagram)DiagramHelper.getService().getDiagramContainer((EObject)semanticDecorators.get(0));
        return DiagramServices.getDiagramServices().getAllOwnedElements(diagram, semanticDecorators);
    }

    public boolean hasRelatedConnections(IStructuredSelection selection) {
        return !this.getRelatedConnections(selection).isEmpty();
    }

    public Collection<DEdge> getRelatedConnections(IStructuredSelection selection) {
        List<DSemanticDecorator> semanticDecorators = this.getDSemanticDecoratorsFromSelection(selection);
        DSemanticDiagram diagram = (DSemanticDiagram)DiagramHelper.getService().getDiagramContainer((EObject)semanticDecorators.get(0));
        return DiagramServices.getDiagramServices().getAllEdges(diagram, semanticDecorators);
    }
}

