/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferences;
import org.polarsys.capella.core.commands.preferences.model.ICategoryTreeNode;
import org.polarsys.capella.core.commands.preferences.model.IItemNode;
import org.polarsys.capella.core.commands.preferences.service.IItemDescriptor;
import org.polarsys.capella.core.commands.preferences.service.IItemFilter;

abstract class AbstractCategoryTreeNode
implements ICategoryTreeNode {
    private final CheckboxTreeViewer tree;
    private ICategoryTreeNode[] children;
    private final CategoryPreferences category;
    private final ICategoryTreeNode parent;
    private final IItemFilter filter;

    protected AbstractCategoryTreeNode(CheckboxTreeViewer tree, CategoryPreferences category, ICategoryTreeNode parent, IItemFilter filter) {
        this.tree = tree;
        this.category = category;
        this.parent = parent;
        this.filter = filter;
    }

    protected abstract List<ICategoryTreeNode> createChildren();

    private void initChildren() {
        if (this.children == null) {
            List<ICategoryTreeNode> childList = this.createChildren();
            this.children = childList.toArray(new ICategoryTreeNode[childList.size()]);
        }
    }

    protected boolean isRecursivelyEmpty(CategoryPreferences cat) {
        boolean result = AbstractCategoryTreeNode.getItems(cat, this.getFilter()).isEmpty();
        if (result) {
            Iterator iter = cat.getChildren().iterator();
            while (result && iter.hasNext()) {
                result = this.isRecursivelyEmpty((CategoryPreferences)iter.next());
            }
        }
        return result;
    }

    protected static Set<IItemDescriptor> getItems(CategoryPreferences category, IItemFilter filter) {
        HashSet<IItemDescriptor> filteredItems = new HashSet<IItemDescriptor>();
        for (IItemDescriptor descriptor : category.getItems()) {
            if (!filter.accept(descriptor, null)) continue;
            filteredItems.add(descriptor);
        }
        return filteredItems;
    }

    protected final CheckboxTreeViewer getTree() {
        return this.tree;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    @Override
    public ICategoryTreeNode[] getChildren() {
        this.initChildren();
        return this.children;
    }

    @Override
    public final ICategoryTreeNode getParent() {
        return this.parent;
    }

    @Override
    public CategoryPreferences getCategory() {
        return this.category;
    }

    @Override
    public IItemNode[] getSelectedItems() {
        return new IItemNode[0];
    }

    @Override
    public void applyToPreferences() {
        ICategoryTreeNode[] currentChildren;
        ICategoryTreeNode[] iCategoryTreeNodeArray = currentChildren = this.getChildren();
        int n = currentChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ICategoryTreeNode element = iCategoryTreeNodeArray[n2];
            element.applyToPreferences();
            ++n2;
        }
    }

    @Override
    public void revertFromPreferences() {
        ICategoryTreeNode[] currentChildren;
        ICategoryTreeNode[] iCategoryTreeNodeArray = currentChildren = this.getChildren();
        int n = currentChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ICategoryTreeNode element = iCategoryTreeNodeArray[n2];
            element.revertFromPreferences();
            ++n2;
        }
    }

    @Override
    public void restoreDefaults() {
        ICategoryTreeNode[] currentChildren;
        ICategoryTreeNode[] iCategoryTreeNodeArray = currentChildren = this.getChildren();
        int n = currentChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ICategoryTreeNode element = iCategoryTreeNodeArray[n2];
            element.restoreDefaults();
            ++n2;
        }
    }

    @Override
    public String getDescription() {
        return this.category.getDescription();
    }

    public String toString() {
        return this.getCategory() == null ? "" : this.getCategory().getName();
    }

    @Override
    public IItemFilter getFilter() {
        return this.filter;
    }
}

