/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.polarsys.capella.core.commands.preferences.internalization.l10n.CustomPreferencesMessages;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferences;
import org.polarsys.capella.core.commands.preferences.service.IItemDescriptor;
import org.polarsys.capella.core.commands.preferences.util.UserProfileDescriptor;
import org.polarsys.capella.core.commands.preferences.util.XmlPreferencesConfig;

public class CategoryPreferencesManager {
    private Set<String> projectsNaturesId;
    static final String DEFAULT_CATEGORY_NAME = CustomPreferencesMessages.category_default_name;
    static final String DEFAULT_CATEGORY_DESCRIPTION = CustomPreferencesMessages.category_default_desc;
    private static CategoryPreferencesManager INSTANCE;
    private final CategoryPreferences globalCategory = CategoryPreferences.GLOBAL_NAMESPACE;

    private CategoryPreferencesManager() {
        this.projectsNaturesId = new HashSet<String>(0);
    }

    public static CategoryPreferencesManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CategoryPreferencesManager();
        }
        return INSTANCE;
    }

    public SortedSet<CategoryPreferences> getFirstCategoriesLevel() {
        return this.globalCategory.getChildren();
    }

    public CategoryPreferences getDefaultCategory() {
        return CategoryPreferences.DEFAULT_CATEGORY;
    }

    public CategoryPreferences getCategory(String path) {
        return this.globalCategory.getDescendent(path, true);
    }

    public CategoryPreferences getCategory(CategoryPreferences parent, String path) {
        if (parent == null) {
            return this.globalCategory.getDescendent(path, true);
        }
        return parent.getDescendent(path, true);
    }

    public CategoryPreferences findCategory(String path) {
        return this.globalCategory.getDescendent(path, false);
    }

    public CategoryPreferences findCategory(CategoryPreferences parent, String path) {
        if (parent == null) {
            return this.globalCategory.getDescendent(path, false);
        }
        return parent.getDescendent(path, false);
    }

    public void removeCategory(CategoryPreferences category) {
        IItemDescriptor[] itemsArray;
        CategoryPreferences[] childrenArray;
        if (category.getParent() == null) {
            throw new IllegalArgumentException();
        }
        SortedSet<CategoryPreferences> children = category.getChildren();
        CategoryPreferences[] categoryPreferencesArray = childrenArray = children.toArray(new CategoryPreferences[children.size()]);
        int n = childrenArray.length;
        int n2 = 0;
        while (n2 < n) {
            CategoryPreferences child = categoryPreferencesArray[n2];
            this.removeCategory(child);
            ++n2;
        }
        Set<IItemDescriptor> items = category.getItems();
        IItemDescriptor[] iItemDescriptorArray = itemsArray = items.toArray(new IItemDescriptor[items.size()]);
        int n3 = itemsArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IItemDescriptor constraint = iItemDescriptorArray[n4];
            category.removeItem(constraint);
            ++n4;
        }
        category.getParent().removeChild(category.getId());
    }

    public void removeCategory(String path) {
        CategoryPreferences category = this.findCategory(path);
        if (category != null) {
            this.removeCategory(category);
        }
    }

    public void initDefaultCategory() {
        CategoryPreferences.DEFAULT_CATEGORY.setName(DEFAULT_CATEGORY_NAME);
        CategoryPreferences.DEFAULT_CATEGORY.setDescription(DEFAULT_CATEGORY_DESCRIPTION);
    }

    public void loadProjectsNature(CategoryPreferences parent, IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id != null && !id.isEmpty()) {
            this.projectsNaturesId.add(id);
        }
    }

    public void loadCategories(CategoryPreferences parent, IConfigurationElement element) {
        String description = element.getAttribute("description");
        String name = element.getAttribute("name");
        if (name != null && name.length() > 0) {
            IConfigurationElement[] subcategories;
            CategoryPreferences category = this.getCategory(parent, name);
            category.setName(name);
            category.setDescription(description);
            IConfigurationElement[] iConfigurationElementArray = subcategories = element.getChildren("category");
            int n = subcategories.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement subCategory = iConfigurationElementArray[n2];
                this.loadCategories(category, subCategory);
                ++n2;
            }
            try {
                XmlPreferencesConfig.loadCategoryItems(element, category);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void loadUserProfile() {
        new UserProfileDescriptor("com.thalsegroup.mde.capella.preferences.user.expert.profile", "User Profile");
    }

    public Collection<CategoryPreferences> getMandatoryCategories() {
        ArrayList<CategoryPreferences> result = new ArrayList<CategoryPreferences>();
        this.globalCategory.getMandatoryCategories(result);
        return result;
    }

    public Set<String> getProjectsNaturesIds() {
        return this.projectsNaturesId;
    }
}

