/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.polarsys.capella.core.commands.preferences.service.IItemDescriptor;
import org.polarsys.capella.core.commands.preferences.service.IItemListener;
import org.polarsys.capella.core.commands.preferences.service.ItemChangeEvent;
import org.polarsys.capella.core.commands.preferences.service.ItemChangeEventType;
import org.polarsys.capella.core.preferences.commands.exceptions.ItemExistsException;

public class PreferencesItemsRegistry {
    private static PreferencesItemsRegistry INSTANCE;
    private static IItemDescriptor profileDescriptor;
    private final Map<String, IItemDescriptor> descriptors = new HashMap<String, IItemDescriptor>();
    private volatile IItemListener[] itemListeners;

    public static IItemDescriptor getProfileDescriptor() {
        return profileDescriptor;
    }

    public static void setProfileDescriptor(IItemDescriptor profileDescriptor_p) {
        profileDescriptor = profileDescriptor_p;
    }

    private PreferencesItemsRegistry() {
    }

    public static PreferencesItemsRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PreferencesItemsRegistry();
        }
        return INSTANCE;
    }

    public boolean isHandled(String commandId) {
        return this.descriptors.containsKey(commandId);
    }

    public IItemDescriptor getDescriptor(String id) {
        return this.descriptors.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IItemDescriptor> getAllDescriptors() {
        Map<String, IItemDescriptor> map = this.descriptors;
        synchronized (map) {
            return new ArrayList<IItemDescriptor>(this.descriptors.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IItemDescriptor descriptor) throws ItemExistsException {
        try {
            boolean registered;
            Map<String, IItemDescriptor> map = this.descriptors;
            synchronized (map) {
                registered = this.doRegister(descriptor);
            }
            if (registered) {
                this.broadcastItemChangeEvent(new ItemChangeEvent(descriptor, ItemChangeEventType.REGISTERED));
            }
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void registerUserProfile(IItemDescriptor descriptor) throws ItemExistsException {
        IItemDescriptor existing = PreferencesItemsRegistry.getProfileDescriptor();
        if (existing == null) {
            profileDescriptor = descriptor;
        } else if (existing != descriptor) {
            throw new ItemExistsException(profileDescriptor.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IItemDescriptor descriptor) {
        boolean unregistered;
        assert (descriptor != null);
        Map<String, IItemDescriptor> map = this.descriptors;
        synchronized (map) {
            unregistered = this.descriptors.remove(descriptor.getId()) != null;
        }
        if (unregistered) {
            this.broadcastItemChangeEvent(new ItemChangeEvent(descriptor, ItemChangeEventType.UNREGISTERED));
        }
    }

    public synchronized void addItemListener(IItemListener listener) {
        if (this.indexOf(listener) < 0) {
            if (this.itemListeners == null) {
                this.itemListeners = new IItemListener[]{listener};
            } else {
                IItemListener[] newListeners = new IItemListener[this.itemListeners.length + 1];
                System.arraycopy(this.itemListeners, 0, newListeners, 0, this.itemListeners.length);
                newListeners[this.itemListeners.length] = listener;
                this.itemListeners = newListeners;
            }
        }
    }

    public synchronized void removeItemListener(IItemListener listener) {
        int index = this.indexOf(listener);
        if (index >= 0) {
            IItemListener[] newListeners = new IItemListener[this.itemListeners.length - 1];
            System.arraycopy(this.itemListeners, 0, newListeners, 0, index);
            System.arraycopy(this.itemListeners, index + 1, newListeners, index, this.itemListeners.length - index - 1);
            this.itemListeners = newListeners;
        }
    }

    private int indexOf(IItemListener listener) {
        int result = -1;
        if (this.itemListeners != null) {
            int i = 0;
            while (i < this.itemListeners.length) {
                if (this.itemListeners[i] == listener) {
                    result = i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void broadcastItemChangeEvent(ItemChangeEvent event) {
        IItemListener[] array;
        if (this.itemListeners == null) {
            return;
        }
        IItemListener[] iItemListenerArray = array = this.itemListeners;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IItemListener element = iItemListenerArray[n2];
            try {
                element.itemChanged(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private boolean doRegister(IItemDescriptor descriptor) throws ItemExistsException {
        boolean result = false;
        String id = descriptor.getId();
        IItemDescriptor existing = this.descriptors.get(id);
        if (existing == null) {
            result = true;
            this.descriptors.put(id, descriptor);
        } else if (existing != descriptor) {
            throw new ItemExistsException(id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bulkRegister(Collection<? extends IItemDescriptor> items) throws ItemExistsException {
        ArrayList<IItemDescriptor> registered = new ArrayList<IItemDescriptor>(items.size());
        Map<String, IItemDescriptor> map = this.descriptors;
        synchronized (map) {
            for (IItemDescriptor iItemDescriptor : items) {
                if (!this.doRegister(iItemDescriptor)) continue;
                registered.add(iItemDescriptor);
            }
        }
        if (!registered.isEmpty()) {
            ItemChangeEvent event = new ItemChangeEvent(null, ItemChangeEventType.REGISTERED);
            for (IItemDescriptor iItemDescriptor : registered) {
                event.setItemDescriptor(iItemDescriptor);
                this.broadcastItemChangeEvent(event);
            }
        }
    }
}

