/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commands.preferences.service.IPropertyPersistentPreferenceStore;
import org.polarsys.capella.core.preferences.Activator;

public class PropertyStore
extends PreferenceStore
implements IPropertyPersistentPreferenceStore,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String USEPROJECTSETTINGS = "useProjectSettings";
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private static Set<IPropertyChangeListener> guestListener = new HashSet<IPropertyChangeListener>();
    private IResource resource;
    private IPreferenceStore workbenchStore;
    private boolean inserting = false;
    private boolean isCanceled;
    private ProjectScope scope;

    public IResource getResource() {
        return this.resource;
    }

    public PropertyStore(IResource _resource, IPreferenceStore _workbenchStore) {
        this.resource = _resource;
        this.workbenchStore = _workbenchStore;
        Activator.getDefault().setPropertyStore(_resource, (IPreferenceStore)this);
        this.scope = new ProjectScope((IProject)this.resource);
        this.scope.getNode("org.polarsys.capella.core.preferences").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.initilizeGuestListeners();
    }

    public void dispose() {
        this.scope.getNode("org.polarsys.capella.core.preferences").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    @Override
    public void initilizeGuestListeners() {
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String name = event.getProperty();
                try {
                    PropertyStore.this.setProperty(name, PropertyStore.this.getString(name));
                }
                catch (IOException exception) {
                    logger.warn((Object)"PropertyStore : ", (Throwable)exception);
                }
            }
        });
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        for (IPropertyChangeListener iPropertyChangeListener : guestListener) {
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent(event.getSource(), event.getKey(), event.getOldValue(), event.getNewValue()));
        }
    }

    @Override
    public void save() throws IOException {
        try {
            if (this.resource instanceof IProject && !this.isCanceled) {
                this.resource.setPersistentProperty(new QualifiedName("org.polarsys.capella.core.preferences", USEPROJECTSETTINGS), "true");
                this.writeProperties();
                this.scope.getNode("org.polarsys.capella.core.preferences").flush();
            }
        }
        catch (Exception exception) {
            logger.warn((Object)"PropertyStore : ", (Throwable)exception);
        }
    }

    private void writeProperties() throws IOException {
        String[] stringArray = this.preferenceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.scope.getNode("org.polarsys.capella.core.preferences").put(name, this.getString(name));
            this.setProperty(name, this.getString(name));
            ++n2;
        }
    }

    private void setProperty(String name, String value) throws IOException {
        try {
            this.scope.getNode("org.polarsys.capella.core.preferences").put(name, value);
            this.resource.setPersistentProperty(new QualifiedName("org.polarsys.capella.core.preferences", name), value);
        }
        catch (CoreException e) {
            throw new IOException("PropertyStore.Cannot_write_resource_property" + name, e);
        }
    }

    public boolean getDefaultBoolean(String name) {
        return this.workbenchStore.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.workbenchStore.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.workbenchStore.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.workbenchStore.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.workbenchStore.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.workbenchStore.getDefaultString(name);
    }

    public boolean getBoolean(String name) {
        this.insertValue(name);
        return super.getBoolean(name);
    }

    public double getDouble(String name) {
        this.insertValue(name);
        return super.getDouble(name);
    }

    public float getFloat(String name) {
        this.insertValue(name);
        return super.getFloat(name);
    }

    public int getInt(String name) {
        this.insertValue(name);
        return super.getInt(name);
    }

    public long getLong(String name) {
        this.insertValue(name);
        return super.getLong(name);
    }

    public String getString(String name) {
        this.insertValue(name);
        return super.getString(name);
    }

    private synchronized void insertValue(String name) {
        if (this.inserting) {
            return;
        }
        if (super.contains(name)) {
            return;
        }
        this.inserting = true;
        String prop = null;
        try {
            prop = this.getProperty(name);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (prop == null) {
            prop = this.workbenchStore.getString(name);
        }
        if (prop != null) {
            this.setValue(name, prop);
        }
        this.inserting = false;
    }

    private String getProperty(String name) throws CoreException {
        return this.resource.getPersistentProperty(new QualifiedName("org.polarsys.capella.core.preferences", name));
    }

    public boolean contains(String name) {
        return this.workbenchStore.contains(name);
    }

    public void setToDefault(String name) {
        this.setValue(name, this.getDefaultString(name));
    }

    public boolean isDefault(String name) {
        String defaultValue = this.getDefaultString(name);
        if (defaultValue == null) {
            return false;
        }
        return defaultValue.equals(this.getString(name));
    }

    public static void addToGuestListener(IPropertyChangeListener listener) {
        guestListener.add(listener);
    }

    public void setCanceled(boolean b) {
        this.isCanceled = true;
    }
}

