/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.ui.sirius;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.capella.core.commands.preferences.service.AbstractDefaultPreferencePage;
import org.polarsys.capella.core.commands.preferences.service.PreferenceField;
import org.polarsys.capella.core.commands.preferences.service.UserProfileModeEnum;
import org.polarsys.capella.core.commands.preferences.ui.sirius.Messages;
import org.polarsys.capella.core.preferences.Activator;

public class CapellaDiagramPreferencePage
extends AbstractDefaultPreferencePage {
    private Label previewValueLabel;
    private StringFieldEditor timeZoneFormatFieldEditor;
    private StringFieldEditor dateFormatFieldEditor;
    private Group dateGroup;

    public CapellaDiagramPreferencePage() {
        super(Messages.PropertyPageId);
    }

    @Override
    protected String getPageTitle() {
        return Messages.PropertyPageTitle;
    }

    @Override
    protected String getPageDescription() {
        return null;
    }

    @Override
    protected void createFieldEditors() {
        Composite fieldEditorParent = this.getFieldEditorParent();
        Group treeContentGroup = this.createGroup(Messages.GroupLabel, Messages.GroupLabel, fieldEditorParent);
        PreferenceField fieldEditorOP1 = new PreferenceField("org.polarsys.capella.core.commands.preferences.ui.sirius.diagrams.navigate.doubleclick", Messages.LabelPrefDisplayNavigateOnDoubleClick, (Composite)treeContentGroup);
        this.addField((FieldEditor)fieldEditorOP1, UserProfileModeEnum.User, (Composite)treeContentGroup, ProjectScope.class);
        fieldEditorOP1.getChangeControl((Composite)treeContentGroup).setToolTipText(Messages.TooltipPrefDisplayNavigateOnDoubleClick);
        this.createDateGroup(fieldEditorParent);
    }

    private void createDateGroup(Composite fieldEditorParent) {
        this.dateGroup = this.createGroup(Messages.DateGroupLabel, Messages.DateGroupLabel, fieldEditorParent);
        this.dateFormatFieldEditor = new StringFieldEditor("dateFormatPreference", Messages.DateFormatLabel, (Composite)this.dateGroup);
        this.dateFormatFieldEditor.getLabelControl((Composite)this.dateGroup).setToolTipText(Messages.DateFormatTooltip);
        this.addField((FieldEditor)this.dateFormatFieldEditor, UserProfileModeEnum.Expert, (Composite)this.dateGroup, null);
        this.dateGroup.setLayout((Layout)new GridLayout(3, false));
        this.addHelpIcon((Composite)this.dateGroup, Messages.DateFormatTooltip);
        this.dateFormatFieldEditor.getTextControl((Composite)this.dateGroup).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CapellaDiagramPreferencePage.this.previewValueLabel.setText(CapellaDiagramPreferencePage.this.computePreview());
            }
        });
        this.timeZoneFormatFieldEditor = new StringFieldEditor("dateTimeZonePreference", Messages.DateTimeZoneLabel, (Composite)this.dateGroup);
        this.timeZoneFormatFieldEditor.getLabelControl((Composite)this.dateGroup).setToolTipText(Messages.DateTimeZoneTooltip);
        this.addField((FieldEditor)this.timeZoneFormatFieldEditor, UserProfileModeEnum.Expert, (Composite)this.dateGroup, null);
        this.dateGroup.setLayout((Layout)new GridLayout(3, false));
        this.addHelpIcon((Composite)this.dateGroup, Messages.DateTimeZoneTooltip);
        this.timeZoneFormatFieldEditor.getTextControl((Composite)this.dateGroup).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CapellaDiagramPreferencePage.this.previewValueLabel.setText(CapellaDiagramPreferencePage.this.computePreview());
            }
        });
        this.dateGroup.setLayout((Layout)new GridLayout(3, false));
        Label previewLabel = new Label((Composite)this.dateGroup, 0);
        previewLabel.setText(Messages.DatePreviewLabel);
        this.previewValueLabel = new Label((Composite)this.dateGroup, 0);
        this.previewValueLabel.setText(this.computePreview());
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 200;
        this.previewValueLabel.setLayoutData((Object)gd);
    }

    private void addHelpIcon(Composite parent, String tooltip) {
        Label image = new Label(parent, 0);
        image.setImage(Activator.getImageDescriptor("prefshelp.gif").createImage());
        image.setToolTipText(tooltip);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        image.setLayoutData((Object)gd);
    }

    String computePreview() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormatFieldEditor.getTextControl((Composite)this.dateGroup).getText());
        String timeZoneForDateFormatting = this.timeZoneFormatFieldEditor.getTextControl((Composite)this.dateGroup).getText();
        if ("SYSTEM".equals(timeZoneForDateFormatting)) {
            timeZoneForDateFormatting = TimeZone.getDefault().getID();
        }
        sdf.setTimeZone(TimeZone.getTimeZone(timeZoneForDateFormatting));
        return sdf.format(date);
    }
}

