/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commands.preferences.service.PropertyStore;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;
import org.polarsys.capella.core.commands.preferences.util.CapellaPreferencesService;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;

public class PreferencesHelper {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    public static final String CONFUGRATION_PROJECT_NATURE_ID = "org.polarsys.capella.core.preferences.project.nature.configNature";
    public static final String CAPELLA_PROJECT_NATURE_ID = "org.polarsys.capella.project.nature";

    private PreferencesHelper() {
    }

    public static IProject getSelectedEclipseProject() {
        IProject sourceProject = PreferencesHelper.getSelectedCapellaProject();
        try {
            IProject[] referencedProjects;
            IProject[] iProjectArray = referencedProjects = sourceProject != null ? sourceProject.getReferencedProjects() : new IProject[]{};
            if (referencedProjects.length != 0) {
                IProject referencedProject = iProjectArray[0];
                return referencedProject;
            }
        }
        catch (Exception exception) {
            StringBuilder loggerMessage = new StringBuilder("could not found the selected resource");
            __logger.debug((Object)loggerMessage.toString(), (Throwable)exception);
        }
        return sourceProject;
    }

    public static boolean hasConfigurationProject(IProject project) {
        boolean existe = false;
        try {
            if (project.getReferencedProjects() != null && project.getReferencedProjects().length > 0 && project.getReferencedProjects()[0].isAccessible() && project.getReferencedProjects()[0].isOpen()) {
                existe = project.getReferencedProjects()[0].hasNature(CONFUGRATION_PROJECT_NATURE_ID);
            }
        }
        catch (CoreException exception) {
            return existe;
        }
        return existe;
    }

    public static IProject getReferencedProjectConfiguration(IProject capellaProject) {
        try {
            return capellaProject.getReferencedProjects()[0];
        }
        catch (CoreException exception) {
            StringBuilder loggerMessage = new StringBuilder("PreferencesHelper.getReferencedProjectConfiguration(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
            return null;
        }
    }

    public static IProject getSelectedCapellaProject() {
        IEditorInput iEditorInput;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = window != null ? window.getActivePage() : null;
        ISelection activeSelection = activePage != null ? activePage.getSelection() : null;
        IEditorPart activeEditor = activePage != null ? activePage.getActiveEditor() : null;
        IProject capellaProject = null;
        if (activeSelection != null && !activeSelection.isEmpty() && activeSelection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)activeSelection;
            Object a = structSel.iterator().next();
            if (a instanceof IProject) {
                capellaProject = (IProject)a;
            } else if (a instanceof IFile) {
                capellaProject = ((IFile)a).getProject();
            } else {
                a = CapellaAdapterHelper.resolveSemanticObject(a);
                capellaProject = PreferencesHelper.getProject((EObject)a);
            }
        } else if (activeEditor != null && (iEditorInput = activeEditor.getEditorInput()) instanceof URIEditorInput) {
            Session session;
            SessionEditorInput sessionEditorInput;
            URIEditorInput uriEditorImput = (URIEditorInput)iEditorInput;
            URI uri = uriEditorImput.getURI();
            IFile resourceFile = PreferencesHelper.getFileFromUri(uri);
            if (resourceFile == null && uriEditorImput instanceof SessionEditorInput && (sessionEditorInput = (SessionEditorInput)uriEditorImput).getStatus().isOK() && (session = sessionEditorInput.getSession()) != null) {
                Resource sessionResource = session.getSessionResource();
                URI sessionResourceURI = sessionResource.getURI();
                resourceFile = PreferencesHelper.getFileFromUri(sessionResourceURI);
            }
            if (resourceFile != null) {
                capellaProject = resourceFile.getProject();
            }
        } else if (activeEditor != null && activeEditor.getEditorInput() != null && activeEditor.getEditorInput().getName() != null) {
            capellaProject = PreferencesHelper.getProjectByEditorName(activeEditor.getEditorInput().getName());
        }
        return capellaProject;
    }

    private static IProject getProjectByEditorName(String name) {
        IProject[] iProjects;
        IProject[] iProjectArray = iProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject targetProject = iProjectArray[n2];
            try {
                if (targetProject.isOpen() && targetProject.isAccessible() && CapellaResourceHelper.isCapellaProject((IProject)targetProject) && targetProject.getName().equals(name)) {
                    return targetProject;
                }
            }
            catch (Exception exception) {
                StringBuilder loggerMessage = new StringBuilder("PreferencesHelper.getProjectByEditorName(..) _ ");
                __logger.error((Object)loggerMessage.toString(), (Throwable)exception);
            }
            ++n2;
        }
        return null;
    }

    public static IProject getProject(EObject object) {
        Resource sessionResource;
        URI sessionResourceURI;
        IFile resourceFile;
        IProject result = null;
        Session session = new EObjectQuery(object).getSession();
        if (session != null && (resourceFile = PreferencesHelper.getFileFromUri(sessionResourceURI = (sessionResource = session.getSessionResource()).getURI())) != null) {
            result = resourceFile.getProject();
        }
        if (result == null) {
            return EcoreUtil2.getProject((EObject)object);
        }
        return result;
    }

    public static IFile getFileFromUri(URI uri) {
        IFile result = null;
        if (uri != null && uri.isPlatformResource()) {
            String platformString = uri.toPlatformString(true);
            result = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
        }
        return result;
    }

    public static ScopedPreferenceStore getProjectScopeOld(IProject targetProject) {
        IScopeContext scope = targetProject != null ? ScopedCapellaPreferencesStore.getProjectScope(targetProject) : null;
        try {
            if (scope != null) {
                IEclipsePreferences node = scope.getNode("org.polarsys.capella.core.preferences");
                node.flush();
                ScopedCapellaPreferencesStore.getProjectContexts().put(targetProject.getProject(), scope);
                return new ScopedPreferenceStore(scope, "org.polarsys.capella.core.preferences");
            }
        }
        catch (Exception exception) {
            StringBuilder loggerMessage = new StringBuilder("Activator.getProjectScope(..) _ ");
            __logger.error((Object)loggerMessage.toString(), (Throwable)exception);
            return new ScopedPreferenceStore(scope, "org.polarsys.capella.core.preferences");
        }
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.polarsys.capella.core.preferences");
    }

    public static ScopedPreferenceStore getProjectScope(IProject targetProject) {
        IScopeContext scope = targetProject != null ? ScopedCapellaPreferencesStore.getProjectScope(targetProject) : null;
        try {
            if (scope != null) {
                ScopedCapellaPreferencesStore.getProjectContexts().put(targetProject.getProject(), scope);
                return ScopedCapellaPreferencesStore.getInstance("org.polarsys.capella.core.preferences");
            }
        }
        catch (Exception exception) {
            StringBuilder loggerMessage = new StringBuilder("Activator.getProjectScope(..) _ ");
            __logger.error((Object)loggerMessage.toString(), (Throwable)exception);
            return new ScopedPreferenceStore(scope, "org.polarsys.capella.core.preferences");
        }
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.polarsys.capella.core.preferences");
    }

    public static ScopedPreferenceStore getDefaultProjectScope(IProject targetProject) {
        IScopeContext scope = targetProject != null ? ScopedCapellaPreferencesStore.getProjectScope(targetProject) : null;
        try {
            if (scope != null) {
                IEclipsePreferences node = scope.getNode("org.polarsys.capella.core.preferences");
                node.flush();
                ScopedCapellaPreferencesStore.getProjectContexts().put(targetProject.getProject(), scope);
                return ScopedCapellaPreferencesStore.getInstance("org.polarsys.capella.core.preferences");
            }
        }
        catch (Exception exception) {
            StringBuilder loggerMessage = new StringBuilder("Activator.getProjectScope(..) _ ");
            __logger.error((Object)loggerMessage.toString(), (Throwable)exception);
            return new ScopedPreferenceStore(scope, "org.polarsys.capella.core.preferences");
        }
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.polarsys.capella.core.preferences");
    }

    public static ScopedPreferenceStore getDefaultProjectScopeOld(IProject targetProject) {
        IScopeContext scope = targetProject != null ? ScopedCapellaPreferencesStore.getProjectScope(targetProject) : null;
        try {
            if (scope != null) {
                IEclipsePreferences node = scope.getNode("org.polarsys.capella.core.preferences");
                node.flush();
                ScopedCapellaPreferencesStore.getProjectContexts().put(targetProject.getProject(), scope);
                return new ScopedPreferenceStore(scope, "org.polarsys.capella.core.preferences");
            }
        }
        catch (Exception exception) {
            StringBuilder loggerMessage = new StringBuilder("Activator.getProjectScope(..) _ ");
            __logger.error((Object)loggerMessage.toString(), (Throwable)exception);
            return new ScopedPreferenceStore(scope, "org.polarsys.capella.core.preferences");
        }
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.polarsys.capella.core.preferences");
    }

    public static List<IPreferenceStore> getAllPreferencesStores() {
        IProject[] iProjects;
        ArrayList<IPreferenceStore> scopes = new ArrayList<IPreferenceStore>();
        IProject[] iProjectArray = iProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject targetProject = iProjectArray[n2];
            try {
                if (targetProject.isOpen() && targetProject.isAccessible() && CapellaResourceHelper.isCapellaProject((IProject)targetProject)) {
                    IScopeContext projectScope = ScopedCapellaPreferencesStore.getProjectScope(targetProject);
                    scopes.add((IPreferenceStore)new ScopedPreferenceStore(projectScope, "org.polarsys.capella.core.preferences"));
                }
            }
            catch (Exception exception) {
                StringBuilder loggerMessage = new StringBuilder("PreferencesHelper.getAllStores(..) _ ");
                __logger.error((Object)loggerMessage.toString(), (Throwable)exception);
            }
            ++n2;
        }
        return scopes;
    }

    public static boolean isConfigurationProject(IProject targetProject) {
        try {
            if (targetProject.isOpen() && targetProject.isAccessible() && targetProject.getNature(CONFUGRATION_PROJECT_NATURE_ID) != null) {
                return true;
            }
        }
        catch (CoreException exception) {
            StringBuilder loggerMessage = new StringBuilder("PreferencesHelper.getAllStores(..) _ ");
            __logger.error((Object)loggerMessage.toString(), (Throwable)exception);
        }
        return false;
    }

    public static boolean isCapellaProject(IProject targetProject) {
        try {
            if (targetProject.isOpen() && targetProject.isAccessible() && CapellaResourceHelper.isCapellaProject((IProject)targetProject)) {
                return true;
            }
        }
        catch (Exception exception) {
            StringBuilder loggerMessage = new StringBuilder("PreferencesHelper.getAllStores(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
        }
        return false;
    }

    public static IProject getCapellaProjectFromSelectedElement(ISelectionProvider selectionProvider) {
        ISelection activeSelection = selectionProvider.getSelection();
        IProject capellaProject = null;
        if (activeSelection != null && !activeSelection.isEmpty() && activeSelection instanceof IStructuredSelection) {
            Object a = ((IStructuredSelection)activeSelection).iterator().next();
            if (a instanceof IProject) {
                capellaProject = (IProject)a;
            } else {
                a = CapellaAdapterHelper.resolveSemanticObject(a);
                capellaProject = PreferencesHelper.getProject((EObject)a);
            }
        }
        return capellaProject;
    }

    public static String getActivePerpectiveId() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && !wb.isStarting()) {
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            IWorkbenchPage page = win != null ? win.getActivePage() : null;
            IPerspectiveDescriptor perspective = page != null ? page.getPerspective() : null;
            return perspective != null ? perspective.getId() : null;
        }
        return null;
    }

    public static List<IFile> retrieveUserDefinedPreferenceFiles(ISelectionProvider selectionProvider, final String epf_file_extension) {
        IProject project = PreferencesHelper.getCapellaProjectFromSelectedElement(selectionProvider);
        final ArrayList<IFile> result = new ArrayList<IFile>();
        if (project == null) {
            return result;
        }
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IProject configurationProject;
                    IProject prj = resource != null ? resource.getProject() : null;
                    IProject iProject = configurationProject = prj != null && prj.isOpen() && prj.getReferencedProjects().length > 0 ? prj.getReferencedProjects()[0] : null;
                    if (configurationProject != null) {
                        IFolder preferenceFolder;
                        IFolder iFolder = preferenceFolder = configurationProject.getProject() != null && configurationProject.getProject().getFolder(".settings/") != null ? configurationProject.getProject().getFolder(".settings/") : null;
                        if (preferenceFolder != null) {
                            PreferencesHelper.getPreferencesFiles(result, (IContainer)configurationProject.getProject(), configurationProject.getProject().getName(), epf_file_extension);
                            return false;
                        }
                    }
                    return true;
                }
            }, 2, 1);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    static List<IFile> getPreferencesFiles(List<IFile> result, IContainer container, String projectName, String epf_file_extension) {
        try {
            if (container != null) {
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IFile) {
                        String ext = resource.getFileExtension();
                        if (epf_file_extension.equals(ext)) {
                            result.add((IFile)resource);
                        }
                    } else if (resource instanceof IFolder) {
                        IFolder settingsFolder = (IFolder)resource;
                        List<IFile> files = PreferencesHelper.getFiles(settingsFolder, epf_file_extension);
                        for (IFile preferencesFile : files) {
                            java.net.URI preferenceFileURI = preferencesFile.getLocationURI();
                            preferencesFile.createLink(preferenceFileURI, 256, null);
                        }
                        PreferencesHelper.getPreferencesFiles(result, (IContainer)settingsFolder, projectName, epf_file_extension);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
        return result;
    }

    public static List<IFile> getFiles(IFolder folder, String extension) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = folder.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 1: {
                        String fileExtension = resource.getFileExtension().toLowerCase();
                        if (!fileExtension.equals(extension) && !fileExtension.equals("*")) break;
                        result.add((IFile)resource);
                        break;
                    }
                    case 2: {
                        IFolder subFolder = (IFolder)resource;
                        result.addAll(PreferencesHelper.getFiles(subFolder, extension));
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void initializeCapellaPreferencesFromEPFFile() {
        CapellaPreferencesService service = new CapellaPreferencesService();
        try {
            Platform.getApplicationArgs();
            String epfFile = CapellaPreferencesService.getEPFPathFromApplicationArguments();
            if (epfFile != null && !epfFile.isEmpty()) {
                PreferencesHelper.restoreAllPreferencesToDefault();
                FileInputStream fileInStream = new FileInputStream(new File(epfFile));
                service.initializePreferences(fileInStream);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static void restoreAllPreferencesToDefault() throws BackingStoreException {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IEclipsePreferences rootNode = PreferencesService.getDefault().getRootNode();
                Preferences instNode = rootNode.node("instance");
                Preferences configScope = rootNode.node("configuration");
                Preferences projectScope = rootNode.node("project");
                try {
                    PreferencesHelper.clearAll(instNode);
                    PreferencesHelper.clearAll(configScope);
                    PreferencesHelper.clearAll(projectScope);
                }
                catch (BackingStoreException exception) {
                    __logger.error((Object)exception.getMessage());
                }
            }
        });
    }

    static void clearAll(Preferences node) throws BackingStoreException {
        String[] names;
        node.clear();
        String[] stringArray = names = node.childrenNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            PlatformUI.getPreferenceStore().setToDefault(name);
            ++n2;
        }
    }

    public static void removeEclipseProjectReferences(String capellaPerspectiveId) {
        if (capellaPerspectiveId.equals(PreferencesHelper.getActivePerpectiveId())) {
            PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
            pm.remove("org.eclipse.ui.propertypages.project.reference");
        }
    }

    public static boolean isNonReferencesCapellaProject(Object source, Project capellaProject, Session session) {
        boolean result = false;
        if (source instanceof PropertyStore) {
            PropertyStore property = (PropertyStore)source;
            IResource resource = property.getResource();
            if (resource != null) {
                IProject project = resource.getProject();
                if (project != null && PreferencesHelper.isConfigurationProject(project)) {
                    IFile resourceFile;
                    if (capellaProject != null && session != null && session.getSessionResource() != null && (resourceFile = PreferencesHelper.getFileFromUri(session.getSessionResource().getURI())) != null) {
                        IProject eclipseProject = resourceFile.getProject();
                        result = PreferencesHelper.isReferencedProject(project, eclipseProject);
                    }
                } else if (project != null && capellaProject != null && PreferencesHelper.getProject((EObject)capellaProject) != null) {
                    return project.equals((Object)PreferencesHelper.getProject((EObject)capellaProject));
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    private static boolean isReferencedProject(IProject project, IProject eclipseProject) {
        boolean existe;
        block4: {
            existe = false;
            try {
                if (eclipseProject.getReferencedProjects() == null || eclipseProject.getReferencedProjects().length <= 0 || !eclipseProject.getReferencedProjects()[0].isAccessible()) break block4;
                IProject[] iProjectArray = eclipseProject.getReferencedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject referencedProject = iProjectArray[n2];
                    if (referencedProject.equals((Object)project)) {
                        existe = true;
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException exception) {
                return existe;
            }
        }
        return existe;
    }
}

